/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.item;

import java.util.List;
import java.util.Locale;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.api.core.Size;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFFoodEnum;
import joshie.harvest.core.helpers.TextHelper;
import joshie.harvest.core.util.interfaces.ISizeable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHFSizeable<I extends ItemHFFoodEnum, E extends Enum<E> & ISizeable>
extends ItemHFFoodEnum<I, E>
implements ISizedProvider<E> {
    public ItemHFSizeable(Class<E> clazz) {
        this(HFTab.FARMING, clazz);
    }

    public ItemHFSizeable(CreativeTabs tab, Class<E> clazz) {
        super(tab, clazz);
        for (Enum e : this.values) {
            for (Size size : Size.values()) {
                long value = ((ISizeable)((Object)e)).getSellValue(size);
                if (value <= 0L) continue;
                HFApi.shipping.registerSellable(this.getStack(e, size), value);
            }
        }
    }

    @Override
    public E getEnumFromStack(ItemStack stack) {
        int real = (int)Math.floor(stack.func_77952_i() / 3);
        int id = Math.max(0, Math.min(this.values.length - 1, real));
        return (E)this.values[id];
    }

    @Override
    public ItemStack getStackFromEnum(E e) {
        return ((ISizeable)e).getStack((Item)this, Size.SMALL);
    }

    @Override
    public ItemStack getStackFromEnum(E e, int amount) {
        return ((ISizeable)e).getStackOfSize((Item)this, Size.SMALL, amount);
    }

    public ItemStack getStack(E e, Size size) {
        return ((ISizeable)e).getStack((Item)this, size);
    }

    public ItemStack getStackOfSize(E e, Size size, int amount) {
        return ((ISizeable)e).getStackOfSize((Item)this, size, amount);
    }

    public Size getSize(ItemStack stack) {
        return Size.values()[Math.min(2, stack.func_77952_i() % 3)];
    }

    public E getObject(ItemStack stack) {
        return this.getEnumFromStack(stack);
    }

    public E getObjectFromString(String string) {
        for (Enum e : this.values) {
            if (!((IStringSerializable)e).func_176610_l().equalsIgnoreCase(string)) continue;
            return (E)e;
        }
        return (E)this.values[0];
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String size = TextHelper.translate("sizeable." + this.getSize(stack).name().toLowerCase(Locale.ENGLISH));
        String name = TextHelper.translate(this.prefix + "." + ((IStringSerializable)this.getEnumFromStack(stack)).func_176610_l());
        String format = TextHelper.translate("sizeable.format");
        return String.format(format, size, name);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 11 + stack.func_77952_i() + ((Enum)this.getEnumFromStack(stack)).ordinal() * 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Enum e : this.values) {
            for (Size size : Size.values()) {
                list.add(((ISizeable)((Object)e)).getStack(item, size));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (Enum e : this.values) {
            for (Size size : Size.values()) {
                ItemStack stack = ((ISizeable)((Object)e)).getStack(item, size);
                ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), ((IStringSerializable)e).func_176610_l() + "_" + size.func_176610_l()));
            }
        }
    }
}

