/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.item;

import java.util.List;
import java.util.Locale;
import joshie.harvest.core.base.item.ItemHFFood;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.core.util.Text;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemHFFoodEnum<I extends ItemHFFoodEnum, E extends Enum<E>>
extends ItemHFFood<I>
implements ICreativeSorted {
    protected final Class<E> enumClass;
    protected final E[] values;
    protected final String prefix;

    public ItemHFFoodEnum(Class<E> clazz) {
        this.enumClass = clazz;
        this.values = (Enum[])clazz.getEnumConstants();
        this.prefix = clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.func_77627_a(true);
    }

    public ItemHFFoodEnum(CreativeTabs tab, Class<E> clazz) {
        super(tab);
        this.enumClass = clazz;
        this.values = (Enum[])clazz.getEnumConstants();
        this.prefix = clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.func_77627_a(true);
    }

    public I setUnlocalizedName(String name) {
        super.func_77655_b(name);
        return (I)this;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public E getEnumFromStack(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return null;
        }
        return this.getEnumFromMeta(stack.func_77952_i());
    }

    public E getEnumFromMeta(int meta) {
        if (meta < 0 || meta >= this.values.length) {
            meta = 0;
        }
        return this.values[meta];
    }

    public ItemStack getStackFromEnum(E e) {
        return new ItemStack((Item)this, 1, ((Enum)e).ordinal());
    }

    public ItemStack getStackFromEnum(E e, int size) {
        return new ItemStack((Item)this, size, ((Enum)e).ordinal());
    }

    public ItemStack getStackFromEnumString(String name) {
        return this.getStackFromEnum(Enum.valueOf(this.enumClass, name.toUpperCase()));
    }

    public String func_77667_c(ItemStack stack) {
        return this.prefix + "_" + ((Enum)this.getEnumFromStack(stack)).name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Text.translate(this.func_77667_c(stack).replaceAll("(.)([A-Z])", "$1$2").toLowerCase(Locale.ENGLISH).replace("_", "."));
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 500;
    }

    public boolean shouldDisplayInCreative(E e) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (E e : this.values) {
            if (!this.shouldDisplayInCreative(e)) continue;
            list.add(new ItemStack(item, 1, ((Enum)e).ordinal()));
        }
    }

    protected String getPrefix(E e) {
        return e.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (E e : this.values) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Enum)e).ordinal(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), ((IStringSerializable)e).func_176610_l()));
        }
    }
}

