/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.gui;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.cooking.gui.GuiCookbook;
import joshie.harvest.core.base.gui.BookPage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;

public abstract class GuiBaseBook
extends GuiScreen {
    private final ArrayList<Runnable> runnables = new ArrayList();
    private final ArrayList<String> tooltip = new ArrayList();
    private final ResourceLocation left;
    private final ResourceLocation right;
    private final int backgroundWidth;
    private final int backgroundHeight;
    private static BookPage page;
    private int xSize = 176;
    private int ySize = 166;
    public int guiLeft;
    public int guiTop;
    private int centreX;
    private int centreY;

    public GuiBaseBook(ResourceLocation left, ResourceLocation right, int backgroundWidth, int backgroundHeight) {
        this.left = left;
        this.right = right;
        this.xSize = backgroundWidth * 2;
        this.ySize = backgroundHeight;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        page = page != null ? page : this.getDefaultPage();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        page.initGui(this, this.field_146292_n, this.field_146293_o);
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.centreX = this.field_146294_l / 2 - this.backgroundWidth;
        this.centreY = (this.field_146295_m - this.backgroundHeight) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(GuiCookbook.RIGHT_GUI);
        this.func_73729_b(this.centreX + this.backgroundWidth, this.centreY, 0, 0, this.backgroundWidth, this.backgroundHeight);
        this.field_146297_k.func_110434_K().func_110577_a(GuiCookbook.LEFT_GUI);
        this.func_73729_b(this.centreX, this.centreY, 102, 0, this.backgroundWidth, this.backgroundHeight);
        this.runnables.clear();
        this.tooltip.clear();
        super.func_73863_a(x, y, partialTicks);
        page.drawScreen(x, y);
        this.drawTooltip(this.tooltip, x, y);
        this.runnables.forEach(Runnable::run);
    }

    public BookPage getPage() {
        return page;
    }

    public void setPage(BookPage page) {
        GuiBaseBook.page = page;
        this.func_73866_w_();
    }

    public void addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public void addTooltip(String string) {
        this.tooltip.add(string);
    }

    public void addTooltip(List<String> list) {
        this.tooltip.addAll(list);
    }

    public abstract BookPage getDefaultPage();

    private void drawTooltip(List<String> list, int x, int y) {
        if (!list.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (String s : list) {
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            if (j2 + k > this.field_146294_l) {
                j2 -= 28 + k;
            }
            if (k2 + i1 + 6 > this.field_146295_m) {
                k2 = this.field_146295_m - i1 - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int j1 = -299950305;
            this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = -296727220;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = list.get(i2);
                this.field_146289_q.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }
}

