/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import joshie.harvest.core.base.gui.ContainerBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends GuiScreen {
    private Container container;
    protected boolean hasInventory;
    private ResourceLocation TEXTURE;
    private static final int nameHeight = 5;
    private static final int inventOffset = 3;
    private final ArrayList<String> tooltip = new ArrayList();
    private final String name;
    public int xSize = 176;
    public int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int mouseWheel;

    public GuiBase(ContainerBase container, String texture, int yOffset) {
        this.container = container;
        this.TEXTURE = new ResourceLocation("harvestfestival", "textures/gui/" + texture + ".png");
        this.ySize += yOffset;
        this.xSize = 201;
        this.name = "";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.container;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.drawBackground(this.guiLeft, this.guiTop);
        this.drawTooltip(this.tooltip, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawForeground(mouseX, mouseY);
        if (this.hasInventory) {
            this.field_146289_q.func_78276_b(this.getName(), this.getX(), 5, 0x404040);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 3, 0x404040);
        }
        this.tooltip.clear();
        RenderHelper.func_74520_c();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return (pointX -= this.guiLeft) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= this.guiTop) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return 46;
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void drawForeground(int x, int y) {
    }

    public void drawBackground(int x, int y) {
    }

    public void addTooltip(List<String> list) {
        this.tooltip.addAll(list);
    }

    private void drawTooltip(List<String> list, int x, int y) {
        if (!list.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (String s : list) {
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            if (j2 + k > this.field_146294_l) {
                j2 -= 28 + k;
            }
            if (k2 + i1 + 6 > this.field_146295_m) {
                k2 = this.field_146295_m - i1 - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int j1 = -299950305;
            this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = -296727220;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = list.get(i2);
                this.field_146289_q.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public void func_146274_d() throws IOException {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = x - this.guiLeft;
        this.mouseY = y - this.guiTop;
        this.mouseWheel = Mouse.getDWheel();
        super.func_146274_d();
    }

    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        this.onMouseClick(this.mouseX, this.mouseY);
    }

    protected void onMouseClick(int mouseX, int mouseY) {
    }
}

