/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.crops.HFCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHFLeaves<B extends BlockHFLeaves, E extends Enum<E>>
extends BlockHFEnum<B, E>
implements IShearable {
    private int[] surroundings;

    public BlockHFLeaves(Class<E> clazz, CreativeTabs tab) {
        super(Material.field_151584_j, clazz, tab);
        this.func_149675_a(true);
        this.setHardness(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public BlockHFLeaves(Class<E> clazz) {
        this(clazz, (CreativeTabs)HFTab.FARMING);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int i1;
        int l;
        int k = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(k - 2, (l = pos.func_177956_o()) - 2, (i1 = pos.func_177952_p()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                        if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                        iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            int l2;
            int k = pos.func_177958_n();
            int l = pos.func_177956_o();
            int i1 = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (worldIn.func_175707_a(new BlockPos(k - 5, l - 5, i1 - 5), new BlockPos(k + 5, l + 5, i1 + 5))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2));
                            Block block = iblockstate.func_177230_c();
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(worldIn, pos);
            }
        }
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack((Block)this, 1, ((Enum)this.getEnumFromState(state)).ordinal());
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, this.getEnumFromMeta(meta)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return super.func_176201_c(state);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= super.func_176201_c(state);
        if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150345_g);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return (MCClientHelper.getMinecraft().field_71474_y.field_74347_j || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this, 1, super.func_176201_c(world.func_180495_p(pos))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)HFCrops.NO_LEAVES);
        super.registerModels(item, name);
    }
}

