/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.block;

import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.IFaceable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHFEnumRotatableTile<B extends BlockHFEnumRotatableTile, E extends Enum<E>>
extends BlockHFEnum<B, E> {
    protected static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockHFEnumRotatableTile(Material material, Class<E> clazz, CreativeTabs tab) {
        super(material, clazz, tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockHFEnumRotatableTile(Material material, Class<E> clazz) {
        this(material, clazz, HFTab.FARMING);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, FACING});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FACING});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IFaceable) {
            ((IFaceable)tile).setFacing(EntityHelper.getFacingFromEntity(entity));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IFaceable) {
            return state.func_177226_a((IProperty)FACING, (Comparable)((IFaceable)tile).getFacing());
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < this.values.length; ++i) {
            if (Character.toLowerCase(this.property.func_177701_a().charAt(0)) < Character.toLowerCase('f')) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), this.property.func_177701_a() + "=" + ((IStringSerializable)this.getEnumFromMeta(i)).func_176610_l() + ",facing=north"));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "facing=north," + this.property.func_177701_a() + "=" + ((IStringSerializable)this.getEnumFromMeta(i)).func_176610_l()));
        }
    }
}

