/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.block;

import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.helpers.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHFEnumRotatableMeta<B extends BlockHFEnumRotatableMeta, E extends Enum<E>>
extends BlockHFEnum<B, E> {
    protected static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockHFEnumRotatableMeta(Material material, Class<E> clazz, CreativeTabs tab) {
        super(material, clazz, tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public BlockHFEnumRotatableMeta(Material material, Class<E> clazz) {
        this(material, clazz, HFTab.FARMING);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, FACING});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FACING});
    }

    @Override
    public ItemStack getStackFromEnum(E e) {
        return new ItemStack((Block)this, 1, ((Enum)e).ordinal());
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, this.getEnumFromMeta(meta)).func_177226_a((IProperty)FACING, (Comparable)this.getFacingFromMeta(meta));
    }

    public EnumFacing getFacingFromMeta(int meta) {
        return EnumFacing.values()[2 + meta / this.values.length % 4];
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int enumValue = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal();
        int faceValue = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        return enumValue + this.values.length * enumValue + faceValue;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = EntityHelper.getFacingFromEntity(placer);
        world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < this.values.length; ++i) {
            if (Character.toLowerCase(this.property.func_177701_a().charAt(0)) < Character.toLowerCase('f')) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), this.property.func_177701_a() + "=" + ((IStringSerializable)this.getEnumFromMeta(i)).func_176610_l() + ",facing=north"));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "facing=north," + this.property.func_177701_a() + "=" + ((IStringSerializable)this.getEnumFromMeta(i)).func_176610_l()));
        }
    }
}

