/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.block;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHFEnum<B extends BlockHFEnum, E extends Enum<E>>
extends BlockHFBase<B> {
    protected static PropertyEnum<?> temporary;
    public final PropertyEnum<E> property;
    protected final Class<E> enumClass;
    protected final E[] values;

    public BlockHFEnum(Material material, Class<E> clazz, CreativeTabs tab) {
        super(BlockHFEnum.preInit(material, clazz), tab);
        this.enumClass = clazz;
        this.property = temporary;
        this.values = (Enum[])clazz.getEnumConstants();
        this.func_180632_j(this.field_176227_L.func_177621_b());
        for (E e : this.values) {
            this.setHarvestLevel(this.getToolType(e), this.getToolLevel(e), this.getStateFromEnum(e));
        }
    }

    private static Material preInit(Material material, Class clazz) {
        temporary = PropertyEnum.func_177709_a((String)clazz.getSimpleName().toLowerCase(Locale.ENGLISH), (Class)clazz);
        return material;
    }

    public BlockHFEnum(Material material, Class<E> clazz) {
        this(material, clazz, HFTab.FARMING);
    }

    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.property, this.getEnumFromMeta(meta));
    }

    public IBlockState getStateFromEnum(E e) {
        return this.func_176223_P().func_177226_a(this.property, e);
    }

    public E getEnumFromBlockPos(IBlockAccess world, BlockPos pos) {
        return this.getEnumFromState(world.func_180495_p(pos));
    }

    public E getEnumFromState(IBlockState state) {
        return (E)((Enum)((Object)state.func_177229_b(this.property)));
    }

    public E getEnumFromMeta(int meta) {
        if (meta < 0 || meta >= this.values.length) {
            meta = 0;
        }
        return this.values[meta];
    }

    public E getEnumFromStack(ItemStack stack) {
        return this.getEnumFromMeta(stack.func_77952_i());
    }

    public ItemStack getStackFromEnum(E e) {
        return new ItemStack((Block)this, 1, ((Enum)e).ordinal());
    }

    public ItemStack getStackFromEnumString(String name) {
        return this.getStackFromEnum(Enum.valueOf(this.enumClass, name.toUpperCase()));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.property))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public String getToolType(E type) {
        return "pickaxe";
    }

    protected int getToolLevel(E level) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int side) {
        return !this.doesDrop(state) ? null : super.func_180660_a(state, rand, side);
    }

    protected boolean doesDrop(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return ((Enum)this.getEnumFromMeta(stack.func_77952_i())).name().toLowerCase(Locale.ENGLISH);
    }

    protected boolean shouldDisplayInCreative(E e) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (E e : this.values) {
            if (!this.shouldDisplayInCreative(e)) continue;
            list.add(new ItemStack(item, 1, ((Enum)e).ordinal()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < this.values.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), this.property.func_177701_a() + "=" + ((IStringSerializable)this.getEnumFromMeta(i)).func_176610_l()));
        }
    }
}

