/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.block;

import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemBlockHF;
import joshie.harvest.core.util.Text;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHFBase<B extends BlockHFBase>
extends Block {
    private String unlocalizedName;

    public BlockHFBase(Material material, CreativeTabs tab) {
        super(material);
        this.func_149647_a(tab);
    }

    public BlockHFBase(Material material) {
        this(material, HFTab.FARMING);
    }

    public B register(String name) {
        this.unlocalizedName = "harvestfestival." + name.replace("_", ".");
        this.func_149663_c(name.replace("_", "."));
        this.setRegistryName(new ResourceLocation("harvestfestival", name));
        GameRegistry.register((IForgeRegistryEntry)this);
        ItemBlockHF item = this.getItemBlock();
        if (item != null) {
            item.register(name);
        }
        return (B)((Object)this);
    }

    public ItemBlockHF getItemBlock() {
        return new ItemBlockHF(this);
    }

    public B setBlockUnbreakable() {
        return (B)((Object)((BlockHFBase)super.func_149722_s()));
    }

    public B setHardness(float hardness) {
        return (B)((Object)((BlockHFBase)super.func_149711_c(hardness)));
    }

    public B setResistance(float value) {
        return (B)((Object)((BlockHFBase)super.func_149752_b(value)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.func_149739_a();
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String unlocalized = this.func_149739_a();
        String name = stack.func_77973_b().func_77667_c(stack);
        return Text.localizeFully(unlocalized + "." + name);
    }

    public int getEntityLifeSpan(ItemStack itemStack, World world) {
        return 6000;
    }

    public int getSortValue(ItemStack stack) {
        return 0;
    }

    public long getSellValue(ItemStack stack) {
        return 0L;
    }

    public String func_149739_a() {
        return this.unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", name), "inventory"));
    }
}

