/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.achievements;

import java.lang.reflect.Field;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.block.BlockFlower;
import joshie.harvest.core.block.BlockStorage;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.block.BlockOre;
import joshie.harvest.mining.item.ItemDarkSpawner;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.item.ItemNPCTool;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@HFLoader
public class HFAchievements {
    public static final AchievementPage PAGE = new AchievementPage("Harvest Festival", new Achievement[0]);
    public static Achievement summon;
    public static Achievement friend;
    public static Achievement marriage;
    public static Achievement harvest;
    public static Achievement onion;
    public static Achievement spinach;
    public static Achievement milker;
    public static Achievement egger;
    public static Achievement milkerLarge;
    public static Achievement eggerLarge;
    public static Achievement firstChristmas;
    public static Achievement birthday;
    public static Achievement firstShipping;
    public static Achievement millionaire;
    public static Achievement theMine;
    public static Achievement killChick;
    public static Achievement killChicken;
    public static Achievement killSheep;
    public static Achievement killCow;
    public static Achievement junk;
    public static Achievement copper;
    public static Achievement silver;
    public static Achievement gold;
    public static Achievement mystril;
    public static Achievement cooking;
    public static Achievement recipes;

    public static void init() {
        AchievementPage.registerAchievementPage((AchievementPage)PAGE);
        summon = HFAchievements.addAchievement("summon", 0, 0, HFCore.FLOWERS.getStackFromEnum(BlockFlower.FlowerType.GODDESS), null);
        friend = HFAchievements.addAchievement("friend", 2, 3, new ItemStack(Items.field_151106_aX), summon);
        marriage = HFAchievements.addAchievement("marriage", 4, 3, HFNPCs.TOOLS.getStackFromEnum(ItemNPCTool.NPCTool.BLUE_FEATHER), summon);
        harvest = HFAchievements.addAchievement("harvest", 0, 4, HFCrops.TURNIP.getCropStack(1), summon);
        onion = HFAchievements.addAchievement("onion", 0, 7, HFCrops.ONION.getCropStack(1), harvest);
        spinach = HFAchievements.addAchievement("spinach", 0, 9, HFCrops.SPINACH.getCropStack(1), harvest);
        milker = HFAchievements.addAchievement("milker", -2, 6, HFAnimals.MILK.getStack(ISizeable.Size.SMALL), harvest);
        egger = HFAchievements.addAchievement("egger", 2, 6, HFAnimals.EGG.getStack(ISizeable.Size.SMALL), harvest);
        milkerLarge = HFAchievements.addAchievement("milkerLarge", -4, 6, HFAnimals.MILK.getStack(ISizeable.Size.LARGE), milker);
        eggerLarge = HFAchievements.addAchievement("eggerLarge", 4, 6, HFAnimals.EGG.getStack(ISizeable.Size.LARGE), egger);
        firstChristmas = HFAchievements.addAchievement("firstChristmas", 2, -3, new ItemStack(Blocks.field_150345_g, 1, 1), summon);
        birthday = HFAchievements.addAchievement("birthday", 2, -5, new ItemStack(Items.field_151105_aU), firstChristmas);
        firstShipping = HFAchievements.addAchievement("firstShipping", -2, 3, HFCore.STORAGE.getStackFromEnum(BlockStorage.Storage.SHIPPING), summon);
        millionaire = HFAchievements.addAchievement("millionaire", -4, 3, new ItemStack(Items.field_151043_k), firstShipping);
        theMine = HFAchievements.addAchievement("theMine", 3, 0, HFMining.ORE.getStackFromEnum(BlockOre.Ore.ROCK), summon);
        killChick = HFAchievements.addAchievement("killChick", 5, -1, HFMining.DARK_SPAWNER.getStackFromEnum(ItemDarkSpawner.DarkSpawner.CHICK), theMine);
        killChicken = HFAchievements.addAchievement("killChicken", 7, -1, HFMining.DARK_SPAWNER.getStackFromEnum(ItemDarkSpawner.DarkSpawner.CHICKEN), killChick);
        killSheep = HFAchievements.addAchievement("killSheep", 9, -1, HFMining.DARK_SPAWNER.getStackFromEnum(ItemDarkSpawner.DarkSpawner.SHEEP), killChicken);
        killCow = HFAchievements.addAchievement("killCow", 11, -1, HFMining.DARK_SPAWNER.getStackFromEnum(ItemDarkSpawner.DarkSpawner.COW), killSheep);
        junk = HFAchievements.addAchievement("junk", 5, 1, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.JUNK), theMine);
        copper = HFAchievements.addAchievement("copper", 7, 1, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.COPPER), junk);
        silver = HFAchievements.addAchievement("silver", 9, 1, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.SILVER), copper);
        gold = HFAchievements.addAchievement("gold", 11, 1, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.GOLD), silver);
        mystril = HFAchievements.addAchievement("mystril", 13, 1, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYSTRIL), gold);
        cooking = HFAchievements.addAchievement("cooking", -2, 0, HFApi.cooking.getBestMeal("turnip_pickled"), summon);
        recipes = HFAchievements.addAchievement("recipes", -4, 0, CookingHelper.getRecipe("turnip_pickled"), summon);
    }

    private static Achievement addAchievement(String name, int column, int row, ItemStack stack, Achievement parent) {
        Achievement achievement = new Achievement("harvestfestival.achievement." + name.replace("_", "."), "harvestfestival." + name, column, row, stack, parent);
        achievement.func_75971_g();
        PAGE.getAchievements().add(achievement);
        return achievement;
    }

    public static void remap() throws Exception {
        HFAchievements.setFinalField(harvest, HFCrops.TURNIP.getCropStack(1));
        HFAchievements.setFinalField(onion, HFCrops.ONION.getCropStack(1));
        HFAchievements.setFinalField(spinach, HFCrops.SPINACH.getCropStack(1));
        HFAchievements.setFinalField(cooking, HFApi.cooking.getBestMeal("turnip_pickled"));
    }

    private static void setFinalField(Achievement achievement, ItemStack stack) throws Exception {
        Field field = ReflectionHelper.findField(Achievement.class, (String[])new String[]{"theItemStack", "field_75990_d"});
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(achievement, stack);
    }
}

