/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import joshie.harvest.animals.tracker.AnimalTracker;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.CalendarClient;
import joshie.harvest.calendar.CalendarData;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.core.handlers.ClientHandler;
import joshie.harvest.core.handlers.DailyTickHandler;
import joshie.harvest.core.handlers.ServerHandler;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.util.handlers.SideHandler;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.gen.MineManager;
import joshie.harvest.player.PlayerLoader;
import joshie.harvest.player.PlayerTracker;
import joshie.harvest.player.PlayerTrackerClient;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.town.tracker.TownTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HFTrackers {
    @SideOnly(value=Side.CLIENT)
    private static TIntObjectMap<SideHandler> CLIENT_WORLDS;
    private static TIntObjectMap<ServerHandler> SERVER_WORLDS;
    private static final String CALENDAR_NAME = "HF-Calendar";
    @SideOnly(value=Side.CLIENT)
    private static Calendar CLIENT_CALENDAR;
    private static CalendarServer SERVER_CALENDAR;
    private static final String MINING_NAME = "HF-Mine-Manager";
    private static MineManager MINE_MANAGER;
    @SideOnly(value=Side.CLIENT)
    private static PlayerTracker CLIENT_PLAYER;
    private static final HashMap<UUID, PlayerTrackerServer> SERVER_PLAYERS;

    @SideOnly(value=Side.CLIENT)
    public static void resetClient() {
        CLIENT_WORLDS = new TIntObjectHashMap();
        CLIENT_PLAYER = new PlayerTrackerClient();
        CLIENT_CALENDAR = new CalendarClient();
    }

    public static void resetServer() {
        SERVER_WORLDS.clear();
        SERVER_CALENDAR = null;
        MINE_MANAGER = null;
    }

    @SideOnly(value=Side.CLIENT)
    private static SideHandler getClient(World world) {
        int dimension = world.field_73011_w.getDimension();
        Object handler = (SideHandler)CLIENT_WORLDS.get(dimension);
        if (handler == null) {
            handler = new ClientHandler();
            CLIENT_WORLDS.put(dimension, handler);
            ((SideHandler)handler).setWorld(world);
        }
        return handler;
    }

    private static ServerHandler getServer(World world) {
        ServerHandler handler = (ServerHandler)SERVER_WORLDS.get(world.field_73011_w.getDimension());
        if (handler == null) {
            handler = new ServerHandler(world);
            SERVER_WORLDS.put(world.field_73011_w.getDimension(), (Object)handler);
            handler.setWorld(world);
        }
        return handler;
    }

    private static SideHandler getHandler(World world) {
        return !world.field_72995_K ? HFTrackers.getServer(world) : HFTrackers.getClient(world);
    }

    public static <A extends AnimalTracker> A getAnimalTracker(World world) {
        return (A)HFTrackers.getHandler(world).getAnimalTracker();
    }

    public static <T extends TownTracker> T getTownTracker(World world) {
        return (T)HFTrackers.getHandler(world).getTownTracker();
    }

    public static DailyTickHandler getTickables(World world) {
        return HFTrackers.getServer(world).getTickables();
    }

    public static void markDirty(World world) {
        ((ServerHandler)SERVER_WORLDS.get(world.field_73011_w.getDimension())).markDirty();
    }

    public static void markDirty(int dimension) {
        ((ServerHandler)SERVER_WORLDS.get(dimension)).markDirty();
    }

    public static <C extends Calendar> C getCalendar(World world) {
        return (C)(world.field_72995_K ? CLIENT_CALENDAR : HFTrackers.getServerCalendar(world));
    }

    private static CalendarServer getServerCalendar(World overworld) {
        if (SERVER_CALENDAR == null) {
            CalendarData data = (CalendarData)overworld.getPerWorldStorage().func_75742_a(CalendarData.class, CALENDAR_NAME);
            if (data == null) {
                data = new CalendarData(CALENDAR_NAME);
                overworld.getPerWorldStorage().func_75745_a(CALENDAR_NAME, (WorldSavedData)data);
            }
            SERVER_CALENDAR = data.getCalendar();
            SERVER_CALENDAR.setWorld(data, overworld);
            SERVER_CALENDAR.recalculate(overworld);
        }
        return SERVER_CALENDAR;
    }

    public static void markCalendarDirty() {
        SERVER_CALENDAR.markDirty();
    }

    public static MineManager getMineManager(World world) {
        if (MINE_MANAGER == null && (MINE_MANAGER = (MineManager)world.getPerWorldStorage().func_75742_a(MineManager.class, MINING_NAME)) == null) {
            MINE_MANAGER = new MineManager(MINING_NAME);
            NBTTagCompound tag = world.func_72912_H().func_186347_a(HFMining.MINE_WORLD);
            if (tag.func_74764_b("MineManager") && tag.func_74775_l("MineManager").func_74764_b("PortalCoordinates")) {
                MINE_MANAGER.func_76184_a(tag.func_74775_l("MineManager"));
                MINE_MANAGER.func_76185_a();
            }
            world.getPerWorldStorage().func_75745_a(MINING_NAME, (WorldSavedData)MINE_MANAGER);
        }
        return MINE_MANAGER;
    }

    public static Collection<PlayerTrackerServer> getPlayerTrackers() {
        return SERVER_PLAYERS.values();
    }

    @SideOnly(value=Side.CLIENT)
    public static PlayerTrackerClient getClientPlayerTracker() {
        return (PlayerTrackerClient)CLIENT_PLAYER;
    }

    public static <P extends PlayerTracker> P getPlayerTrackerFromPlayer(EntityPlayer player) {
        return HFTrackers.getPlayerTracker(player.field_70170_p, EntityHelper.getPlayerUUID(player));
    }

    public static <P extends PlayerTracker> P getPlayerTracker(World world, UUID uuid) {
        if (world.field_72995_K) {
            return (P)CLIENT_PLAYER;
        }
        PlayerTracker tracker = SERVER_PLAYERS.get(uuid);
        return (P)(tracker != null ? tracker : PlayerLoader.getDataFromUUID(null, uuid));
    }

    public static void setPlayerData(UUID uuid, PlayerTrackerServer data) {
        SERVER_PLAYERS.put(uuid, data);
    }

    static {
        SERVER_WORLDS = new TIntObjectHashMap();
        SERVER_PLAYERS = new HashMap();
    }
}

