/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.crops.HFCrops;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.tools.HFTools;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFLoader(priority=0)
public class HFTab
extends CreativeTabs {
    public static final HFTab TOWN = new HFTab("town");
    public static final HFTab MINING = new HFTab("mining");
    public static final HFTab FARMING = new HFTab("farming");
    public static final HFTab COOKING = new HFTab("cooking");
    public static final HFTab GATHERING = new HFTab("gathering");
    public static CreativeTabs[] tabs = new CreativeTabs[0];
    private ItemStack icon = new ItemStack(Items.field_151013_M);

    public HFTab(String label) {
        super(label);
        this.func_78025_a("hf.png");
        this.func_78014_h();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_78024_c() {
        return "harvestfestival.tab." + this.func_78013_b();
    }

    public ItemStack func_151244_d() {
        return this.icon;
    }

    public Item func_78016_d() {
        return this.icon.func_77973_b();
    }

    public boolean hasSearchBar() {
        return true;
    }

    public int getSearchbarWidth() {
        return 69;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(List<ItemStack> list) {
        super.func_78018_a(list);
        Collections.sort(list, new Alphabetical());
    }

    public void setStack(ItemStack stack) {
        this.icon = stack;
    }

    public static void remap() {
        TOWN.setStack(new ItemStack((Item)HFBuildings.STRUCTURES, 1, 0));
        MINING.setStack(HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.JUNK));
        FARMING.setStack(HFCrops.STRAWBERRY.getCropStack(1));
        COOKING.setStack(HFApi.cooking.getMeal("salad"));
        GATHERING.setStack(new ItemStack((Item)HFTools.AXE, 1, 0));
    }

    private static class Alphabetical
    implements Comparator<Object> {
        private Alphabetical() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            ItemStack stack1 = (ItemStack)o1;
            ItemStack stack2 = (ItemStack)o2;
            Item item1 = stack1.func_77973_b();
            Item item2 = stack2.func_77973_b();
            int value1 = 500;
            int value2 = 500;
            if (item1 instanceof ICreativeSorted) {
                value1 = ((ICreativeSorted)item1).getSortValue(stack1);
            } else if (HFApi.crops.getCropFromStack(stack1) != null) {
                value1 = 0;
            }
            if (item2 instanceof ICreativeSorted) {
                value2 = ((ICreativeSorted)item2).getSortValue(stack2);
            } else if (HFApi.crops.getCropFromStack(stack2) != null) {
                value2 = 0;
            }
            return value1 == value2 ? stack1.func_82833_r().compareTo(stack2.func_82833_r()) : (value1 > value2 ? 1 : -1);
        }
    }
}

