/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class HFRecipeFixes {
    public static void complete() {
        HFRecipeFixes.fixRecipes(Items.field_151110_aK, null);
        HFRecipeFixes.fixRecipes(Items.field_151172_bF, "Carrot");
        HFRecipeFixes.fixRecipes(Items.field_151174_bG, "Potato");
        HFRecipeFixes.fixRecipes(Items.field_151015_O, "Wheat");
    }

    public static void fixRecipes(Item fix, String name) {
        for (IRecipe recipe : (ArrayList)CraftingManager.func_77594_a().func_77592_b()) {
            if (recipe instanceof ShapedRecipes) {
                HFRecipeFixes.overrideShaped((ShapedRecipes)recipe, fix);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                HFRecipeFixes.overrideShapeless((ShapelessRecipes)recipe, fix);
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                HFRecipeFixes.overrideShapedOre((ShapedOreRecipe)recipe, fix, name);
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe)) continue;
            HFRecipeFixes.overrideShapelessOre((ShapelessOreRecipe)recipe, fix, name);
        }
    }

    private static void overrideShapelessOre(ShapelessOreRecipe recipe, Item fix, String name) {
        ArrayList original = recipe.getInput();
        ArrayList clone = new ArrayList(original.size());
        boolean hasChanged = false;
        for (int i = 0; i < original.size(); ++i) {
            Object o = original.get(i);
            if (o == null || !(o instanceof ItemStack)) {
                clone.add(o);
                continue;
            }
            ItemStack stack = (ItemStack)o;
            Item item = stack.func_77973_b();
            if (item == fix) {
                Object add;
                if (name == null) {
                    add = new ItemStack(fix, 1, Short.MAX_VALUE);
                    add.func_77982_d(stack.func_77978_p());
                } else {
                    add = "crop" + name;
                }
                clone.add(add);
                hasChanged = true;
                continue;
            }
            clone.add(stack.func_77946_l());
        }
        if (hasChanged) {
            HFRecipeFixes.override(recipe, clone);
        }
    }

    private static void overrideShapedOre(ShapedOreRecipe recipe, Item fix, String name) {
        Object[] original = recipe.getInput();
        Object[] clone = new Object[original.length];
        boolean hasChanged = false;
        for (int i = 0; i < original.length; ++i) {
            Object o = original[i];
            if (o == null || !(o instanceof ItemStack)) {
                clone[i] = o;
                continue;
            }
            ItemStack stack = (ItemStack)o;
            Item item = stack.func_77973_b();
            if (item == fix) {
                clone[i] = null;
                if (name == null) {
                    clone[i] = new ItemStack(fix, 1, Short.MAX_VALUE);
                    ((ItemStack)clone[i]).func_77982_d(stack.func_77978_p());
                } else {
                    clone[i] = "crop" + name;
                }
                hasChanged = true;
                continue;
            }
            clone[i] = ((ItemStack)original[i]).func_77946_l();
        }
        if (hasChanged) {
            HFRecipeFixes.override(recipe, clone);
        }
    }

    private static void overrideShapeless(ShapelessRecipes recipe, Item fix) {
        ArrayList original = (ArrayList)recipe.field_77579_b;
        ArrayList<ItemStack> clone = new ArrayList<ItemStack>(original.size());
        boolean hasChanged = false;
        while (clone.size() < original.size()) {
            clone.add(null);
        }
        for (int i = 0; i < original.size(); ++i) {
            ItemStack stack = (ItemStack)original.get(i);
            if (stack == null) {
                clone.set(i, null);
                continue;
            }
            Item item = stack.func_77973_b();
            if (item == fix) {
                ItemStack stack2 = new ItemStack(fix, 1, Short.MAX_VALUE);
                stack2.func_77982_d(stack.func_77978_p());
                clone.set(i, stack2);
                hasChanged = true;
                continue;
            }
            clone.set(i, stack);
        }
        if (hasChanged) {
            HFRecipeFixes.override(recipe, clone);
        }
    }

    private static void overrideShaped(ShapedRecipes shaped, Item fix) {
        ItemStack[] original = shaped.field_77574_d;
        ItemStack[] clone = new ItemStack[original.length];
        boolean hasChanged = false;
        for (int i = 0; i < original.length; ++i) {
            ItemStack stack = original[i];
            if (stack == null) {
                clone[i] = null;
                continue;
            }
            Item item = stack.func_77973_b();
            if (item == fix) {
                clone[i] = new ItemStack(fix, 1, Short.MAX_VALUE);
                clone[i].func_77982_d(stack.func_77978_p());
                hasChanged = true;
                continue;
            }
            clone[i] = original[i].func_77946_l();
        }
        if (hasChanged) {
            HFRecipeFixes.override(shaped, clone);
        }
    }

    private static void override(Object recipe, Object items) {
        try {
            Field field = recipe.getClass().getDeclaredField("recipeItems");
            if (field == null) {
                field = recipe.getClass().getDeclaredField("field_77574_d");
            }
            if (field == null) {
                field = recipe.getClass().getDeclaredField("field_77579_b");
            }
            if (field == null) {
                field = recipe.getClass().getDeclaredField("input");
            }
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(recipe, items);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

