/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core;

import joshie.harvest.HarvestFestival;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.Ore;
import joshie.harvest.core.SetEnum;
import joshie.harvest.core.SetSizeable;
import joshie.harvest.core.block.BlockFlower;
import joshie.harvest.core.block.BlockGoddessWater;
import joshie.harvest.core.block.BlockStorage;
import joshie.harvest.core.handlers.GuiHandler;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.item.ItemSizeable;
import joshie.harvest.core.render.SizeableDefinition;
import joshie.harvest.core.tile.TileShipping;
import joshie.harvest.core.util.HFLoader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

@HFLoader(priority=10)
public class HFCore {
    public static final Fluid GODDESS = HFCore.registerFluid(new Fluid("goddess_water", new ResourceLocation("harvestfestival", "blocks/goddess_still"), new ResourceLocation("harvestfestival", "blocks/goddess_flow")).setRarity(EnumRarity.RARE));
    public static final BlockGoddessWater GODDESS_WATER = new BlockGoddessWater(GODDESS).register("goddess_water");
    public static final BlockFlower FLOWERS = (BlockFlower)((Object)new BlockFlower().register("flowers"));
    public static final BlockStorage STORAGE = (BlockStorage)((Object)new BlockStorage().register("storage"));
    public static final ItemSizeable SIZEABLE = (ItemSizeable)new ItemSizeable().register("sizeable");
    public static final AxisAlignedBB FENCE_COLLISION = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0);
    public static boolean DEBUG_MODE;
    public static boolean SLEEP_ANYTIME;
    public static boolean NO_TICK_OFFLINE;

    public static BlockFlower.EnumFlowerType[] getTypes(BlockFlower.EnumFlowerColor flowerColor) {
        BlockFlower.EnumFlowerType[][] TYPES_FOR_BLOCK = (BlockFlower.EnumFlowerType[][])ReflectionHelper.getPrivateValue(BlockFlower.EnumFlowerType.class, null, (String[])new String[]{"TYPES_FOR_BLOCK", "field_176981_k"});
        return TYPES_FOR_BLOCK[flowerColor.ordinal()];
    }

    public static void preInit() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)HarvestFestival.instance, (IGuiHandler)new GuiHandler());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetEnum.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetSizeable.Serializer());
        RegistryHelper.registerTiles(TileShipping.class);
        GODDESS.setBlock((Block)GODDESS_WATER);
        HFCore.registerIfNotRegistered("flowerSunflower", new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()));
        HFCore.registerIfNotRegistered("flowerLilac", new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()));
        HFCore.registerIfNotRegistered("flowerRose", new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()));
        HFCore.registerIfNotRegistered("flowerPeony", new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()));
        HFCore.registerIfNotRegistered("flowerDandelion", new ItemStack((Block)Blocks.field_150327_N));
        for (BlockFlower.EnumFlowerType type : HFCore.getTypes(BlockFlower.EnumFlowerColor.RED)) {
            HFCore.registerIfNotRegistered("flower" + WordUtils.capitalize((String)type.func_176963_d()), new ItemStack((Block)Blocks.field_150328_O, 1, type.func_176968_b()));
        }
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151115_aP, 1, 0), 20L);
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151115_aP, 1, 1), 60L);
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151115_aP, 1, 2), 100L);
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151115_aP, 1, 3), 100L);
        HFApi.shipping.registerSellable(new ItemStack(Items.field_151025_P), 85L);
    }

    private static void registerIfNotRegistered(String string, ItemStack stack) {
        if (!InventoryHelper.isOreName(stack, string)) {
            OreDictionary.registerOre((String)string, (ItemStack)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        RegistryHelper.registerFluidBlockRendering((Block)GODDESS_WATER, "goddess_water");
        ModelLoader.setCustomMeshDefinition((Item)SIZEABLE, (ItemMeshDefinition)SizeableDefinition.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                BlockFlower.FlowerType type = (BlockFlower.FlowerType)((Object)FLOWERS.getEnumFromState(state));
                if (!type.isColored()) {
                    return -1;
                }
                return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
            }
        }, new Block[]{FLOWERS});
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return ((BlockFlower.FlowerType)((Object)FLOWERS.getEnumFromMeta(stack.func_77952_i()))).isColored() ? ColorizerFoliage.func_77468_c() : -1;
            }
        }, new Block[]{FLOWERS});
        SizeableDefinition.INSTANCE.registerEverything();
    }

    public static void postInit() {
        BlockGoddessWater.VALID_ITEMS.register(Items.field_151034_e);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150392_bi);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150440_ba);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150329_H);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150398_cm);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150328_O);
        BlockGoddessWater.VALID_ITEMS.register(Blocks.field_150327_N);
        BlockGoddessWater.VALID_ITEMS.register(Ore.of("treeLeaves"));
        BlockGoddessWater.VALID_ITEMS.register(Ore.of("treeSapling"));
        BlockGoddessWater.VALID_ITEMS.register(Ore.of("vine"));
        BlockGoddessWater.VALID_ITEMS.register(Ore.of("sugarcane"));
        BlockGoddessWater.VALID_ITEMS.register(Ore.of("blockCactus"));
    }

    private static Fluid registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    public static void configure() {
        DEBUG_MODE = ConfigHelper.getBoolean("Debug Mode", false, "Enabling this adds extra information to items, when you have f3 debug mode on");
        SLEEP_ANYTIME = ConfigHelper.getBoolean("Sleep any time of day", true);
        NO_TICK_OFFLINE = ConfigHelper.getBoolean("Server doesn't update time when no players online", false);
    }
}

