/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.quests.HFQuest;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.commands.AbstractHFCommand;
import joshie.harvest.core.commands.CommandManager;
import joshie.harvest.core.commands.HFCommand;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class HFApiLoader {
    public static void init(@Nonnull ASMDataTable table) {
        HashSet datas = new HashSet(table.getAll(HFApiImplementation.class.getCanonicalName()));
        for (ASMDataTable.ASMData data : datas) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                Object instance = clazz.getField("INSTANCE").get(null);
                Class<?>[] interfaces = clazz.getInterfaces();
                if (interfaces == null || interfaces.length <= 0) continue;
                for (Class<?> inter : interfaces) {
                    for (Field f : HFApi.class.getFields()) {
                        if (!f.getType().equals(inter)) continue;
                        f.set(null, instance);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static <I extends IForgeRegistryEntry.Impl> void load(Class type, IForgeRegistry registry, ResourceLocation resource, Class<I> clazz) {
        try {
            if (type.isAssignableFrom(clazz)) {
                registry.register(((IForgeRegistryEntry.Impl)clazz.newInstance()).setRegistryName(resource));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void load(@Nonnull ASMDataTable asm, boolean isClient) {
        HFApiLoader.registerQuests(asm);
        HFApiLoader.registerEvents(asm, isClient);
        HFApiLoader.registerPackets(asm);
        HFApiLoader.registerCommands(asm);
    }

    private static void registerQuests(@Nonnull ASMDataTable asm) {
        String annotationClassName = HFQuest.class.getCanonicalName();
        HashSet asmDatas = new HashSet(asm.getAll(annotationClassName));
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Map data = asmData.getAnnotationInfo();
                Class<?> clazz = Class.forName(asmData.getClassName());
                String extra = data.get("value") != null ? (String)data.get("value") : "";
                String domain = data.get("mod") != null ? (String)data.get("mod") : "harvestfestival";
                ResourceLocation resource = new ResourceLocation(domain, extra);
                HFApiLoader.load(Quest.class, Quest.REGISTRY, resource, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerCommands(@Nonnull ASMDataTable asm) {
        String annotationClassName = HFCommand.class.getCanonicalName();
        HashSet asmDatas = new HashSet(asm.getAll(annotationClassName));
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (!AbstractHFCommand.class.isAssignableFrom(clazz)) continue;
                CommandManager.INSTANCE.registerCommand((AbstractHFCommand)clazz.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void registerEvents(@Nonnull ASMDataTable asmDataTable, boolean isClient) {
        String annotationClassName = HFEvents.class.getCanonicalName();
        HashSet asmDatas = new HashSet(asmDataTable.getAll(annotationClassName));
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> clazz;
                Method register;
                String side;
                Map data = asmData.getAnnotationInfo();
                String string = side = data.get("value") != null ? (String)ReflectionHelper.getPrivateValue(ModAnnotation.EnumHolder.class, (Object)((ModAnnotation.EnumHolder)data.get("value")), (String[])new String[]{"value"}) : "";
                if ((!side.equals("CLIENT") || !isClient) && !side.equals("") || (register = HFApiLoader.getMethod(clazz = Class.forName(asmData.getClassName()), "register")) != null && !((Boolean)register.invoke(null, new Object[0])).booleanValue()) continue;
                Field INSTANCE = HFApiLoader.getField(clazz, "INSTANCE");
                if (INSTANCE == null) {
                    MinecraftForge.EVENT_BUS.register(clazz.newInstance());
                    continue;
                }
                MinecraftForge.EVENT_BUS.register(INSTANCE.get(null));
            }
            catch (Exception exception) {}
        }
    }

    private static void registerPackets(@Nonnull ASMDataTable asmDataTable) {
        String annotationClassName = Packet.class.getCanonicalName();
        HashSet asmDatas = new HashSet(asmDataTable.getAll(annotationClassName));
        HashMap<String, Side> sidedPackets = new HashMap<String, Side>();
        HashMap<String, String> unsidedPackets = new HashMap<String, String>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Side side;
                String s;
                Map data = asmData.getAnnotationInfo();
                String string = s = data.get("value") != null ? (String)ReflectionHelper.getPrivateValue(ModAnnotation.EnumHolder.class, (Object)((ModAnnotation.EnumHolder)data.get("value")), (String[])new String[]{"value"}) : "BOTH";
                Object object = s.equals("CLIENT") ? Side.CLIENT : (side = s.equals("SERVER") ? Side.SERVER : null);
                if (side == null) {
                    unsidedPackets.put(asmData.getClassName(), asmData.getClassName());
                    continue;
                }
                sidedPackets.put(asmData.getClassName(), side);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Comparator<String> alphabetical = new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
                if (res == 0) {
                    res = str1.compareTo(str2);
                }
                return res;
            }
        };
        ArrayList namesSided = Lists.newArrayList(sidedPackets.keySet());
        Collections.sort(namesSided, alphabetical);
        ArrayList namesUnsided = Lists.newArrayList(unsidedPackets.keySet());
        Collections.sort(namesUnsided, alphabetical);
        for (String sided : namesSided) {
            Side side = (Side)sidedPackets.get(sided);
            try {
                Class<?> asmClass = Class.forName(sided);
                PacketHandler.registerPacket(asmClass, side);
            }
            catch (Exception exception) {}
        }
        for (String unsided : namesUnsided) {
            try {
                Class<?> asmClass = Class.forName(unsided);
                PacketHandler.registerPacket(asmClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Method getMethod(Class clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Field getField(Class clazz, String field) {
        try {
            return clazz.getField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

