/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.tile;

import java.util.ArrayList;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.cooking.IAltItem;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.base.tile.TileFaceable;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.core.helpers.SpawnItemHelper;
import joshie.harvest.core.helpers.StackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public abstract class TileCooking
extends TileFaceable {
    public static final int COOK_TIMER = 100;
    private boolean cooking;
    private short cookTimer = 0;
    private ArrayList<ItemStack> ingredients = new ArrayList();
    protected ItemStack result;
    private int last;
    public final float[] rotations = new float[20];
    public final float[] offset1 = new float[20];
    public final float[] offset2 = new float[20];
    public final float[] heightOffset = new float[20];

    public abstract Utensil getUtensil();

    public boolean isCooking() {
        return this.cooking;
    }

    public int getCookTimer() {
        return this.cookTimer;
    }

    public CookingHelper.PlaceIngredientResult hasPrerequisites() {
        return CookingHelper.PlaceIngredientResult.SUCCESS;
    }

    public boolean isFinishedCooking() {
        return this.result == null;
    }

    public ItemStack getResult() {
        return this.result != null ? this.result.func_77946_l() : this.result;
    }

    public ArrayList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void giveToPlayer(EntityPlayer player) {
        ItemStack theItem = this.getResult();
        if (theItem.func_77942_o()) {
            player.func_71029_a((StatBase)HFAchievements.cooking);
        }
        SpawnItemHelper.addToPlayerInventory(player, theItem);
        this.result = null;
    }

    public void takeBackLastStack(EntityPlayer player) {
        if (this.ingredients.size() > 0) {
            SpawnItemHelper.addToPlayerInventory(player, this.ingredients.get(this.ingredients.size() - 1));
            this.ingredients.remove(this.ingredients.size() - 1);
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.last = this.ingredients.size();
            this.cooking = true;
            this.cookTimer = 0;
            this.func_70296_d();
        }
    }

    public void animate() {
    }

    public short getCookingTime() {
        return 100;
    }

    public void update() {
        if (this.isCooking()) {
            this.animate();
        }
        if (!this.field_145850_b.field_72995_K && this.cooking) {
            this.cookTimer = (short)(this.cookTimer + 1);
            if (this.cookTimer >= this.getCookingTime()) {
                this.result = HFApi.cooking.getResult(this.getUtensil(), this.ingredients);
                this.cooking = false;
                this.ingredients = new ArrayList();
                this.cookTimer = 0;
                this.func_70296_d();
            }
            if (this.hasPrerequisites() != CookingHelper.PlaceIngredientResult.SUCCESS) {
                this.cooking = false;
                this.func_70296_d();
            }
        }
    }

    public boolean addIngredient(ItemStack stack) {
        if (this.ingredients.size() >= 20) {
            return false;
        }
        if (this.hasPrerequisites() != CookingHelper.PlaceIngredientResult.SUCCESS) {
            return false;
        }
        if (!HFApi.cooking.isIngredient(stack)) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        ItemStack clone = this.getRealIngredient(stack);
        clone.field_77994_a = 1;
        this.last = this.ingredients.size();
        this.ingredients.add(clone);
        this.cooking = true;
        this.cookTimer = 0;
        this.func_70296_d();
        return true;
    }

    private ItemStack getRealIngredient(ItemStack stack) {
        ItemStack alt = null;
        if (stack.func_77973_b() instanceof IAltItem) {
            alt = ((IAltItem)stack.func_77973_b()).getAlternativeWhenCooking(stack);
        }
        return alt == null ? stack.func_77946_l() : alt.func_77946_l();
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.doRenderUpdate();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.doRenderUpdate();
    }

    protected void doRenderUpdate() {
        if (this.cooking) {
            this.rotations[this.last] = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
            this.offset1[this.last] = 0.5f - this.field_145850_b.field_73012_v.nextFloat();
            this.offset2[this.last] = this.field_145850_b.field_73012_v.nextFloat() / 1.75f;
            this.heightOffset[this.last] = 0.5f + (float)this.ingredients.size() * 0.001f;
        }
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public void func_70296_d() {
        if (!this.field_145850_b.field_72995_K) {
            MCServerHelper.markForUpdate(this.field_145850_b, this.func_174877_v());
            MCServerHelper.markForUpdate(this.field_145850_b, this.func_174877_v().func_177977_b());
        }
        super.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cooking = nbt.func_74767_n("IsCooking");
        this.cookTimer = nbt.func_74765_d("CookingTimer");
        this.last = nbt.func_74771_c("Last");
        this.ingredients = new ArrayList();
        if (nbt.func_74764_b("IngredientsInside")) {
            NBTTagList is = nbt.func_150295_c("IngredientsInside", 10);
            for (int i = 0; i < is.func_74745_c(); ++i) {
                this.ingredients.add(StackHelper.getItemStackFromNBT(is.func_150305_b(i)));
            }
        }
        this.result = nbt.func_74764_b("Count") ? StackHelper.getItemStackFromNBT(nbt) : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("IsCooking", this.cooking);
        nbt.func_74777_a("CookingTimer", this.cookTimer);
        nbt.func_74774_a("Last", (byte)this.last);
        if (this.ingredients.size() > 0) {
            NBTTagList is = new NBTTagList();
            for (ItemStack ingredient : this.ingredients) {
                is.func_74742_a((NBTBase)StackHelper.writeItemStackToNBT(new NBTTagCompound(), ingredient));
            }
            nbt.func_74782_a("IngredientsInside", (NBTBase)is);
        }
        if (this.result != null) {
            StackHelper.writeItemStackToNBT(nbt, this.result);
        }
        return super.func_189515_b(nbt);
    }

    public boolean isAbove(Utensil utensil) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tile instanceof TileCooking) {
            return ((TileCooking)tile).getUtensil() == utensil;
        }
        return false;
    }

    public static abstract class TileCookingTicking
    extends TileCooking
    implements ITickable {
        public void func_73660_a() {
            super.update();
        }
    }
}

