/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.tile;

import joshie.harvest.api.HFApi;
import joshie.harvest.cooking.tile.TileFridge;
import joshie.harvest.core.helpers.NBTHelper;
import joshie.harvest.core.lib.HFSounds;
import joshie.harvest.core.util.Text;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class FridgeData
implements IInventory {
    protected final ItemStack[] inventory = new ItemStack[54];
    private final TileFridge tile;
    private int players;

    public FridgeData(TileFridge tile) {
        this.tile = tile;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack stack = this.inventory[index];
            this.inventory[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return Text.translate("cookware.fridge");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("hi");
    }

    public int func_70297_j_() {
        return 512;
    }

    public void func_70296_d() {
        this.tile.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        ++this.players;
        if (this.players < 0) {
            this.players = 0;
        }
        player.field_70170_p.func_175641_c(this.tile.func_174877_v(), this.tile.func_145838_q(), 1, this.players);
        this.tile.func_145831_w().func_184148_a(null, (double)this.tile.func_174877_v().func_177958_n(), (double)this.tile.func_174877_v().func_177956_o(), (double)this.tile.func_174877_v().func_177952_p(), HFSounds.FRIDGE, SoundCategory.BLOCKS, 2.0f, this.tile.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_174886_c(EntityPlayer player) {
        --this.players;
        if (this.players < 0) {
            this.players = 0;
        }
        player.field_70170_p.func_175641_c(this.tile.func_174877_v(), this.tile.func_145838_q(), 1, this.players);
        this.tile.func_145831_w().func_184148_a(null, (double)this.tile.func_174877_v().func_177958_n(), (double)this.tile.func_174877_v().func_177956_o(), (double)this.tile.func_174877_v().func_177952_p(), HFSounds.FRIDGE, SoundCategory.BLOCKS, 2.0f, this.tile.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return HFApi.cooking.isIngredient(stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 1) {
            this.players = value;
        }
    }

    public int func_174890_g() {
        return this.players;
    }

    public void func_174888_l() {
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("FridgeContents", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = NBTHelper.readItemStack(tag);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            NBTHelper.writeItemStack(stack, tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("FridgeContents", (NBTBase)itemList);
        return nbt;
    }
}

