/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.render;

import java.util.ArrayList;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.tile.TileCooking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public abstract class SpecialRendererCookware<T extends TileCooking>
extends TileEntitySpecialRenderer<T> {
    public static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public void renderTileEntityAt(T tile, double x, double y, double z, float tick, int destroyStage) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.renderCookware(tile);
        GlStateManager.func_179121_F();
    }

    protected void renderCookware(T tile) {
        ArrayList<ItemStack> ingredients = ((TileCooking)tile).getIngredients();
        ItemStack result = ((TileCooking)tile).getResult();
        if (result != null) {
            this.renderResult(tile, result);
        }
        int fluidId = 0;
        int max = ingredients.size();
        for (int i = 0; i < max; ++i) {
            ItemStack ingredient = ingredients.get(i);
            ResourceLocation fluid = CookingAPI.INSTANCE.getFluid(ingredient);
            if (fluid == null) {
                this.renderIngredient(ingredient, ((TileCooking)tile).heightOffset[i], ((TileCooking)tile).rotations[i], ((TileCooking)tile).offset1[i], ((TileCooking)tile).offset2[i]);
                continue;
            }
            this.renderFluid(fluidId, tile.func_145831_w(), fluid);
            ++fluidId;
        }
    }

    public void renderFluid(int i, World world, ResourceLocation fluid) {
    }

    public abstract void translateIngredient(boolean var1, float var2, float var3, float var4, float var5);

    public void translateResult(boolean isBlock) {
    }

    public void translateResult(T t, boolean isBlock) {
        this.translateResult(isBlock);
    }

    protected void renderIngredient(ItemStack stack, float position, float rotation, float offset1, float offset2) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        this.translateIngredient(stack.func_77973_b() instanceof ItemBlock, position, rotation, offset1, offset2);
        GlStateManager.func_179112_b((int)32771, (int)32772);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MINECRAFT.func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected void renderResult(T t, ItemStack stack) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        this.translateResult(t, stack.func_77973_b() instanceof ItemBlock);
        GlStateManager.func_179112_b((int)32771, (int)32772);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MINECRAFT.func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected void renderFluidPlane(ResourceLocation fluid, float x, float y, float z, float size) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        TextureAtlasSprite sprite = MINECRAFT.func_147117_R().getTextureExtry(fluid.toString());
        if (sprite != null) {
            SpecialRendererCookware.MINECRAFT.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            double uMin = sprite.func_94209_e();
            double uMax = sprite.func_94212_f();
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94210_h();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected void renderFluidCube(ResourceLocation fluid, float x, float y, float z, float size) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        TextureAtlasSprite sprite = MINECRAFT.func_147117_R().getTextureExtry(fluid.toString());
        if (sprite != null) {
            SpecialRendererCookware.MINECRAFT.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            double uMin = sprite.func_94209_e();
            double uMax = sprite.func_94212_f();
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94210_h();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
            vb.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
            vb.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), (double)(-size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }
}

