/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.RecipeHandler;
import joshie.harvest.api.cooking.Utensil;
import net.minecraft.item.ItemStack;

public class RecipeStack
implements RecipeHandler {
    public static final RecipeStack INSTANCE = new RecipeStack();
    private final Set<RecipeVanilla> recipes = new HashSet<RecipeVanilla>();

    private RecipeStack() {
    }

    @Override
    public ItemStack getResult(Utensil utensil, List<ItemStack> stacks, List<Ingredient> ingredients) {
        for (RecipeVanilla recipe : this.recipes) {
            ItemStack ret = recipe.getResult(utensil, ingredients);
            if (ret == null) continue;
            return ret.func_77946_l();
        }
        return null;
    }

    public void addRecipe(ItemStack output, Utensil utensil, Ingredient ... ingredients) {
        this.recipes.add(new RecipeVanilla(utensil, output, ingredients));
    }

    private static class RecipeVanilla {
        public final ItemStack result;
        private final Ingredient[] requiredIngredients;
        private final Utensil requiredTool;

        private RecipeVanilla(Utensil utensil, ItemStack result, Ingredient ... ingredients) {
            this.requiredTool = utensil;
            this.requiredIngredients = ingredients;
            this.result = result;
        }

        private boolean recipeHasThisIngredient(Ingredient ingredient) {
            for (Ingredient i : this.requiredIngredients) {
                if (!i.isEqual(ingredient)) continue;
                return true;
            }
            return false;
        }

        private boolean ingredientListContains(List<Ingredient> ingredients, Ingredient required) {
            for (Ingredient passed : ingredients) {
                if (!required.isEqual(passed)) continue;
                return true;
            }
            return false;
        }

        public ItemStack getResult(Utensil utensil, List<Ingredient> ingredients) {
            if (ingredients == null || ingredients.size() < 1 || utensil != this.requiredTool) {
                return null;
            }
            for (Ingredient ingredient : ingredients) {
                if (this.recipeHasThisIngredient(ingredient)) continue;
                return null;
            }
            for (Ingredient required : this.requiredIngredients) {
                if (this.ingredientListContains(ingredients, required)) continue;
                return null;
            }
            return this.result;
        }
    }
}

