/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import joshie.harvest.api.cooking.CookingHandler;
import joshie.harvest.api.cooking.IngredientStack;
import joshie.harvest.api.cooking.Recipe;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.cooking.recipe.RecipeBuilder;
import net.minecraft.item.ItemStack;

public class RecipeMaker
implements CookingHandler {
    public static final RecipeBuilder BUILDER = new RecipeBuilder();

    @Override
    @Nullable
    public List<ItemStack> getResult(Utensil utensil, List<ItemStack> stacks, List<IngredientStack> ingredients) {
        for (Recipe recipe : Recipe.REGISTRY) {
            List<ItemStack> ret = this.findRecipe(utensil, recipe, ingredients);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private List<ItemStack> findRecipe(Utensil utensil, Recipe recipe, List<IngredientStack> ingredients) {
        if (recipe.getUtensil() != utensil) {
            return null;
        }
        if (!this.areIngredientsAllowedInRecipe(recipe, ingredients)) {
            return null;
        }
        if (!RecipeMaker.areAllRequiredInRecipe(recipe.getRequired(), ingredients)) {
            return null;
        }
        return BUILDER.build(recipe, ingredients);
    }

    public static boolean areAllRequiredInRecipe(Collection<IngredientStack> requiredSet, Collection<IngredientStack> ingredients) {
        for (IngredientStack required : requiredSet) {
            if (required.isSame(ingredients)) continue;
            return false;
        }
        return true;
    }

    private boolean isInRecipe(Recipe recipe, IngredientStack stack) {
        for (IngredientStack required : recipe.getRequired()) {
            if (!required.isSame(stack)) continue;
            return true;
        }
        for (IngredientStack optional : recipe.getOptional()) {
            if (!optional.isSame(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean areIngredientsAllowedInRecipe(Recipe recipe, List<IngredientStack> ingredients) {
        for (IngredientStack ingredient : ingredients) {
            if (this.isInRecipe(recipe, ingredient)) continue;
            return false;
        }
        return true;
    }
}

