/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.IngredientStack;
import joshie.harvest.api.cooking.Recipe;
import joshie.harvest.cooking.recipe.HFIngredients;
import joshie.harvest.core.helpers.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeBuilder {
    public static final String FOOD_LEVEL = "FoodLevel";
    public static final String SATURATION_LEVEL = "FoodSaturation";
    private List<IngredientStack> required;
    private List<IngredientStack> optional;
    private int hunger = 0;
    private float saturation;
    private int stackSize;
    private long cost;
    private final ListBuilder toRequired = new ListBuilder(){

        @Override
        protected List<IngredientStack> getList(Recipe recipe) {
            return recipe.getRequired();
        }
    };
    private final ListBuilder toOptional = new ListBuilder(){

        @Override
        protected List<IngredientStack> getList(Recipe recipe) {
            return recipe.getOptional();
        }
    };

    public List<ItemStack> build(Recipe recipe, List<IngredientStack> ingredients) {
        this.required = this.toRequired.toList(recipe, ingredients);
        this.optional = this.toOptional.toList(recipe, ingredients);
        this.stackSize = 1;
        HashSet<Ingredient> removed = new HashSet<Ingredient>();
        for (IngredientStack stack : recipe.getRequired()) {
            if (removed.contains(stack.getIngredient())) continue;
            removed.add(stack.getIngredient());
            this.removeFromList(stack);
        }
        this.calculateHungerSaturationAndRemoveOptionals(recipe, new ArrayList<IngredientStack>(this.optional));
        this.calculateStackSizeBasedOnRequiredListAndRemainingItems(recipe.getRequired());
        this.calculateActualHungerAndSaturationValues(recipe);
        this.calculateCostsBasedOnEverything(recipe);
        if (this.required.size() == 0 || recipe.supportsNBTData()) {
            return this.build(recipe.getStack(), recipe.supportsNBTData());
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.stackSize > 1) {
            ret.add(RecipeBuilder.setFoodStats(StackHelper.toStack((ItemStack)recipe.getStack(), (int)(this.stackSize - 1)), this.hunger, this.saturation, this.cost));
        }
        float multiplier = 1.0f;
        for (int i = 1; i <= this.required.size(); ++i) {
            multiplier += 0.5f / (float)i;
        }
        this.hunger = (int)Math.floor((double)this.hunger * (double)multiplier);
        this.saturation *= multiplier;
        ret.add(RecipeBuilder.setFoodStats(recipe.getStack(), this.hunger, this.saturation, this.cost));
        return ret;
    }

    private List<ItemStack> build(ItemStack basicStack, boolean supportsNBTData) {
        if (!supportsNBTData) {
            return Collections.singletonList(StackHelper.toStack((ItemStack)basicStack, (int)this.stackSize));
        }
        return Collections.singletonList(RecipeBuilder.setFoodStats(StackHelper.toStack((ItemStack)basicStack, (int)this.stackSize), this.hunger, this.saturation, this.cost));
    }

    public static ItemStack setFoodStats(ItemStack stack, int hunger, float saturation, long cost) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a(FOOD_LEVEL, hunger);
        tag.func_74776_a(SATURATION_LEVEL, saturation);
        tag.func_74772_a("SellValue", cost);
        return stack;
    }

    private void calculateCostsBasedOnEverything(Recipe recipe) {
        long sell = 0L;
        for (IngredientStack stack : recipe.getRequired()) {
            if (stack.getIngredient() == HFIngredients.BREAD) {
                sell += 50L;
                continue;
            }
            long internal = stack.getIngredient().getSellValue();
            if (internal == 0L) {
                for (Ingredient ingredient : stack.getIngredient().getEquivalents()) {
                    if (internal != 0L && (ingredient.getSellValue() == 0L || ingredient.getSellValue() >= internal)) continue;
                    internal = ingredient.getSellValue();
                }
                sell += internal;
                continue;
            }
            sell += stack.getIngredient().getSellValue();
        }
        this.cost = (long)((double)sell * 1.12);
    }

    private void calculateActualHungerAndSaturationValues(Recipe recipe) {
        if (this.required.size() > 0) {
            TObjectIntHashMap added = new TObjectIntHashMap();
            for (IngredientStack stack : this.required) {
                Ingredient main = stack.getIngredient();
                if (!added.containsKey((Object)main)) {
                    this.hunger += main.getHunger() / 2;
                    this.saturation += main.getSaturation() / 2.0f;
                    added.put((Object)main, 0);
                    continue;
                }
                int used = added.adjustOrPutValue((Object)main, 1, 1);
                this.hunger = (int)((double)this.hunger + (double)main.getHunger() / (double)(4 * used));
                this.saturation += main.getSaturation() / (float)(4 * used);
            }
        }
        this.hunger = recipe.getHunger() + (int)((double)this.hunger / (double)this.stackSize);
        this.saturation = recipe.getSaturation() + this.saturation / (float)this.stackSize;
    }

    private void calculateStackSizeBasedOnRequiredListAndRemainingItems(List<IngredientStack> required) {
        int totalRecipesMade = 0;
        for (int i = 0; i < 64 && this.areAllRequiredInRecipeAndRemove(required); ++i) {
            ++totalRecipesMade;
        }
        this.stackSize += totalRecipesMade;
    }

    private void removeFromList(IngredientStack required) {
        int removed = 0;
        Iterator<IngredientStack> it = this.required.iterator();
        while (it.hasNext()) {
            if (!required.isSame(it.next())) continue;
            it.remove();
            if (++removed < required.getStackSize()) continue;
            break;
        }
    }

    private boolean areAllRequiredInRecipeAndRemove(List<IngredientStack> requiredSet) {
        for (IngredientStack required : requiredSet) {
            if (required.isSame(this.required)) continue;
            return false;
        }
        for (IngredientStack required : requiredSet) {
            this.removeFromList(required);
        }
        return true;
    }

    private void calculateHungerSaturationAndRemoveOptionals(Recipe recipe, List<IngredientStack> optionals) {
        float hunger = 0.0f;
        float saturation = 0.0f;
        TObjectIntHashMap added = new TObjectIntHashMap();
        for (IngredientStack stack : optionals) {
            Ingredient main = stack.getIngredient();
            if (!added.containsKey((Object)main)) {
                hunger += (float)main.getHunger();
                saturation += main.getSaturation();
                added.put((Object)main, 0);
            } else {
                int used = added.adjustOrPutValue((Object)main, 1, 1);
                hunger = (float)((double)hunger + (double)main.getHunger() / (double)(4 * used));
                saturation += main.getSaturation() / (float)(4 * used);
            }
            if (added.size() < recipe.getMaximumOptionalIngredients()) continue;
            break;
        }
        this.optional.clear();
        this.hunger = (int)Math.floor(hunger);
        this.saturation = saturation;
    }

    private abstract class ListBuilder {
        private ListBuilder() {
        }

        List<IngredientStack> toList(Recipe recipe, List<IngredientStack> ingredients) {
            ArrayList<IngredientStack> list = new ArrayList<IngredientStack>();
            for (IngredientStack required : this.getList(recipe)) {
                for (IngredientStack stack : ingredients) {
                    if (!required.isSame(stack)) continue;
                    list.add(stack);
                }
            }
            return list;
        }

        protected abstract List<IngredientStack> getList(Recipe var1);
    }
}

