/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.Meal;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.recipe.MealBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class MealImpl
extends IForgeRegistryEntry.Impl<MealImpl>
implements Meal {
    private final String name;
    public final MealBuilder result;
    private final Ingredient[] requiredIngredients;
    private ItemStack alt = null;
    private final Utensil requiredTool;
    private Ingredient[] optionalIngredients;

    public MealImpl(String unlocalised, Utensil utensil, Ingredient[] ingredients, MealBuilder result) {
        this.name = unlocalised;
        this.requiredTool = utensil;
        this.requiredIngredients = ingredients;
        this.result = result;
    }

    @Override
    public MealImpl setOptionalIngredients(Ingredient ... ingredients) {
        this.optionalIngredients = ingredients;
        return this;
    }

    @Override
    public MealImpl setIsDrink() {
        this.result.setIsDrink();
        return this;
    }

    @Override
    public MealImpl setAlternativeTexture(ItemStack stack) {
        this.alt = stack;
        return this;
    }

    @Override
    public MealImpl setExhaustion(float value) {
        this.result.setExhaustion(value);
        return this;
    }

    public String getDisplayName() {
        return I18n.func_74838_a((String)this.name);
    }

    public ItemStack getAlternativeItem() {
        return this.alt;
    }

    public Utensil getRequiredTool() {
        return this.requiredTool;
    }

    public Ingredient[] getRequiredIngredients() {
        return this.requiredIngredients;
    }

    private boolean recipeHasThisIngredient(Ingredient ingredient) {
        for (Ingredient i : this.requiredIngredients) {
            if (!i.isEqual(ingredient)) continue;
            return true;
        }
        if (this.optionalIngredients != null) {
            for (Ingredient i : this.optionalIngredients) {
                if (!i.isEqual(ingredient)) continue;
                return true;
            }
        }
        return false;
    }

    private Ingredient getIngredientIfInList(List<Ingredient> ingredients, Ingredient required) {
        for (Ingredient passed : ingredients) {
            if (!required.isEqual(passed)) continue;
            return passed;
        }
        return null;
    }

    public ItemStack getResult(Utensil utensil, List<ItemStack> stacks, List<Ingredient> ingredients) {
        if (ingredients == null || ingredients.size() < 1 || utensil != this.requiredTool) {
            return null;
        }
        for (Ingredient ingredient : ingredients) {
            if (this.recipeHasThisIngredient(ingredient)) continue;
            return null;
        }
        for (Ingredient required : this.requiredIngredients) {
            if (this.getIngredientIfInList(ingredients, required) != null) continue;
            return null;
        }
        MealBuilder meal = new MealBuilder(this.result, stacks);
        if (this.optionalIngredients != null) {
            for (Ingredient optional : this.optionalIngredients) {
                Ingredient ingredient = this.getIngredientIfInList(ingredients, optional);
                if (ingredient == null) continue;
                meal.addIngredient(ingredient);
            }
        }
        return this.cook(meal);
    }

    public MealBuilder getMeal() {
        return new MealBuilder(this.result, this.getIngredientsAsStacks(false));
    }

    private void addStack(List<ItemStack> list, Ingredient ingredient) {
        List<ItemStack> stack = CookingAPI.INSTANCE.getStacksForIngredient(ingredient);
        if (stack.size() > 0 && stack.get(0) != null) {
            list.add(stack.get(0));
        }
    }

    private List<ItemStack> getIngredientsAsStacks(boolean getBest) {
        if (getBest) {
            ArrayList<ItemStack> best = new ArrayList<ItemStack>();
            for (Ingredient ingredient : this.requiredIngredients) {
                this.addStack(best, ingredient);
            }
            if (this.optionalIngredients != null) {
                for (Ingredient ingredient : this.optionalIngredients) {
                    this.addStack(best, ingredient);
                }
            }
            return best;
        }
        ArrayList<ItemStack> basic = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.requiredIngredients) {
            this.addStack(basic, ingredient);
        }
        return basic;
    }

    public MealBuilder getBestMeal() {
        MealBuilder meal = new MealBuilder(this.result, this.getIngredientsAsStacks(true));
        if (this.optionalIngredients != null) {
            for (Ingredient i : this.optionalIngredients) {
                meal.addIngredient(i);
            }
        }
        return meal;
    }

    public ItemStack cook(MealBuilder meal) {
        return meal.cook(new ItemStack((Item)HFCooking.MEAL, 1, CookingAPI.REGISTRY.getValues().indexOf(this)));
    }
}

