/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import com.google.common.collect.ConcurrentHashMultiset;
import java.util.ArrayList;
import java.util.List;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.core.util.holder.ItemStackHolder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MealBuilder {
    public static final ItemStack BURNT = new ItemStack((Item)HFCooking.MEAL);
    private static final double HUNGER_MODIFIER = 1.0;
    private static final double SATURATION_MODIFIER = 1.0;
    private List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private int hunger = 0;
    private float saturation = 0.0f;
    private float exhaustion = 0.0f;
    private int eatTime = 32;
    private boolean isLiquid = false;
    private int hunger_cap = 20;
    private float saturation_cap = 2.0f;

    public MealBuilder(int hunger, float saturation, int eatTime) {
        this.hunger = (int)((double)hunger * 1.0);
        this.saturation = (float)((double)saturation * 1.0);
        this.eatTime = eatTime;
    }

    public MealBuilder(MealBuilder meal, List<ItemStack> stacks) {
        this.ingredients = stacks;
        this.hunger = meal.hunger;
        this.saturation = meal.saturation;
        this.exhaustion = meal.exhaustion;
        this.eatTime = meal.eatTime;
        this.isLiquid = meal.isLiquid;
        this.hunger_cap = meal.hunger_cap;
        this.saturation_cap = meal.saturation_cap;
    }

    public void setIsDrink() {
        this.isLiquid = true;
    }

    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    public MealBuilder addIngredient(Ingredient ingredient) {
        this.eatTime += ingredient.getEatTime();
        this.hunger += ingredient.getHunger();
        this.saturation += ingredient.getSaturation();
        this.exhaustion += ingredient.getExhaustion();
        this.hunger = Math.min(this.hunger_cap, this.hunger);
        this.saturation = Math.min(this.saturation_cap, this.saturation);
        return this;
    }

    public long getSellValue(List<ItemStack> stacks) {
        long value = 0L;
        ConcurrentHashMultiset added = ConcurrentHashMultiset.create();
        for (ItemStack stack : stacks) {
            ItemStackHolder holder = ItemStackHolder.of(stack);
            added.add((Object)holder);
            float percentage = (25.0f + 75.0f / (float)added.count((Object)holder)) / 100.0f;
            value += (long)((int)((float)HFApi.shipping.getSellValue(stack) * percentage));
        }
        return (long)((float)value * 1.25f);
    }

    public ItemStack cook(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("FoodLevel", this.hunger);
        stack.func_77978_p().func_74776_a("FoodSaturation", this.saturation);
        stack.func_77978_p().func_74776_a("FoodExhaustion", this.exhaustion);
        stack.func_77978_p().func_74757_a("IsDrink", this.isLiquid);
        stack.func_77978_p().func_74768_a("EatTime", Math.max(this.eatTime, 8));
        stack.func_77978_p().func_74772_a("SellValue", this.getSellValue(this.ingredients));
        return stack;
    }
}

