/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.recipe;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.item.ItemIngredients;
import joshie.harvest.cooking.render.MappingEvent;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.crops.HFCrops;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@HFLoader(priority=6)
public class HFIngredients {
    public static final Ingredient MUSHROOM = new Ingredient("mushroom");
    public static final Ingredient JUICE_VEGETABLE = new Ingredient("vegetable_juice");
    public static final Ingredient SALAD_INGREDIENT = new Ingredient("salad_ingredient");
    public static final Ingredient SANDWICH_INGREDIENT = new Ingredient("sandwich_ingredient");
    public static final Ingredient SASHIMI_VEGETABLE = new Ingredient("sashimi_vegetable");
    public static final Ingredient FISH = new Ingredient("fish");
    public static final Ingredient MEAT = new Ingredient("meat");
    public static final Ingredient SALT = new Ingredient("salt", 0, 0.05f).setEatTime(0);
    public static final Ingredient SUGAR = new Ingredient("sugar", 2, 0.05f).setEatTime(0);
    public static final Ingredient BUTTER = new Ingredient("butter", 1, 0.06f).setEatTime(-8);
    public static final Ingredient BOILED_EGG = new Ingredient("boiled_egg", 6, 1.14f);
    public static final Ingredient SASHIMI = new Ingredient("sashimi", 6, 1.26f);
    public static final Ingredient SCRAMBLED_EGG = new Ingredient("scrambled_egg", 11, 2.28f);
    public static final Ingredient COOKIES = new Ingredient("cookies", 4, 0.87f);
    public static final Ingredient KETCHUP = new Ingredient("ketchup", 1, 0.06f).setEatTime(0);
    public static final Ingredient APPLE = new Ingredient("apple", 4, 0.6f);
    public static final Ingredient CHOCOLATE = new Ingredient("chocolate", 2, 0.5f);
    public static final Ingredient EGG = new Ingredient("egg", 1, 0.34f);
    public static final Ingredient FLOUR = new Ingredient("flour", 1, 0.2f);
    public static final Ingredient OIL = new Ingredient("oil", 0, 0.1f).setFluid(MappingEvent.OIL).setEatTime(-8);
    public static final Ingredient RICEBALL = new Ingredient("riceball", 1, 0.25f);
    public static final Ingredient MILK = new Ingredient("milk", 1, 0.2f).setFluid(MappingEvent.MILK);
    public static final Ingredient MAYONNAISE = new Ingredient("mayonnaise", 1, 0.5f);
    public static final Ingredient BREAD = new Ingredient("bread", 5, 1.2f);
    public static final Ingredient RED_MUSHROOM = new Ingredient("red_mushroom", 4, 0.5f);
    public static final Ingredient BROWN_MUSHROOM = new Ingredient("brown_mushroom", 2, 0.7f);
    public static final Ingredient BAKED_POTATO = new Ingredient("baked_potato", 5, 1.2f);
    public static final Ingredient TURNIP = HFCrops.TURNIP.getIngredient();
    public static final Ingredient POTATO = HFCrops.POTATO.getIngredient();
    public static final Ingredient CUCUMBER = HFCrops.CUCUMBER.getIngredient();
    public static final Ingredient STRAWBERRY = HFCrops.STRAWBERRY.getIngredient();
    public static final Ingredient CABBAGE = HFCrops.CABBAGE.getIngredient();
    public static final Ingredient TOMATO = HFCrops.TOMATO.getIngredient();
    public static final Ingredient ONION = HFCrops.ONION.getIngredient();
    public static final Ingredient CORN = HFCrops.CORN.getIngredient();
    public static final Ingredient PUMPKIN = HFCrops.PUMPKIN.getIngredient();
    public static final Ingredient PINEAPPLE = HFCrops.PINEAPPLE.getIngredient();
    public static final Ingredient EGGPLANT = HFCrops.EGGPLANT.getIngredient();
    public static final Ingredient CARROT = HFCrops.CARROT.getIngredient();
    public static final Ingredient SWEET_POTATO = HFCrops.SWEET_POTATO.getIngredient();
    public static final Ingredient SPINACH = HFCrops.SPINACH.getIngredient();
    public static final Ingredient GREEN_PEPPER = HFCrops.GREEN_PEPPER.getIngredient();
    public static final Ingredient BEETROOT = HFCrops.BEETROOT.getIngredient();
    public static final Ingredient WATERMELON = HFCrops.WATERMELON.getIngredient();
    public static final Ingredient WHEAT = HFCrops.WHEAT.getIngredient();
    public static final Ingredient CHICKEN = new Ingredient("chicken", 2, 0.6f);
    public static final Ingredient PORK = new Ingredient("pork", 3, 0.6f);
    public static final Ingredient BEEF = new Ingredient("beef", 3, 0.6f);
    public static final Ingredient MUTTON = new Ingredient("mutton", 2, 0.6f);
    public static final Ingredient SALMON = new Ingredient("salmon", 2, 0.2f);
    public static final Ingredient COD = new Ingredient("cod", 2, 0.2f);
    public static final Ingredient RABBIT = new Ingredient("rabbit", 3, 0.6f);
    public static final Ingredient RABBIT_COOKED = new Ingredient("cooked_rabbit", 5, 1.2f);

    public static void preInit() {
        MUSHROOM.add(RED_MUSHROOM, BROWN_MUSHROOM);
        JUICE_VEGETABLE.add(TURNIP, CUCUMBER, CABBAGE, ONION, CARROT, SPINACH, GREEN_PEPPER);
        SALAD_INGREDIENT.add(CUCUMBER, CARROT, TOMATO, CABBAGE, BROWN_MUSHROOM);
        SANDWICH_INGREDIENT.add(CUCUMBER, TOMATO, MAYONNAISE, BROWN_MUSHROOM, BOILED_EGG);
        SASHIMI_VEGETABLE.add(CUCUMBER, TOMATO, ONION, EGGPLANT);
        MEAT.add(CHICKEN, PORK, BEEF, MUTTON, RABBIT);
        FISH.add(SALMON, COD);
    }

    private static String getPrimaryCropName(ItemStack stack) {
        String[] names;
        for (String name : names = InventoryHelper.getOreNames(stack)) {
            if (!name.startsWith("crop")) continue;
            return name;
        }
        return null;
    }

    public static void postInit() {
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151110_aK), EGG);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151117_aB), MILK);
        CookingAPI.INSTANCE.register(HFAnimals.EGG.getStack(ISizeable.Size.SMALL), EGG);
        CookingAPI.INSTANCE.register(HFAnimals.MILK.getStack(ISizeable.Size.SMALL), MILK);
        CookingAPI.INSTANCE.register(HFAnimals.MAYONNAISE.getStack(ISizeable.Size.SMALL), MAYONNAISE);
        for (Crop crop : Crop.REGISTRY) {
            if (crop == Crop.NULL_CROP || crop.getIngredient() == null) continue;
            ItemStack stack = crop.getCropStack(1);
            String name = HFIngredients.getPrimaryCropName(stack);
            if (name != null) {
                HFIngredients.registerForOre(name, crop.getIngredient());
                continue;
            }
            CookingAPI.INSTANCE.register(stack, crop.getIngredient());
        }
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151034_e), APPLE);
        CookingAPI.INSTANCE.register(new ItemStack(Blocks.field_150440_ba), WATERMELON);
        CookingAPI.INSTANCE.register(new ItemStack((Block)Blocks.field_150338_P), BROWN_MUSHROOM);
        CookingAPI.INSTANCE.register(new ItemStack((Block)Blocks.field_150337_Q), RED_MUSHROOM);
        HFIngredients.registerForOre("foodChocolatebar", CHOCOLATE);
        HFIngredients.registerForOre("foodFlour", FLOUR);
        HFIngredients.registerForOre("foodOliveoil", OIL);
        CookingAPI.INSTANCE.register(HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.RICEBALL), RICEBALL);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("butter"), BUTTER);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("egg_boiled"), BOILED_EGG);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("sashimi"), SASHIMI);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("egg_scrambled"), SCRAMBLED_EGG);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("cookies"), COOKIES);
        CookingAPI.INSTANCE.register(CookingAPI.INSTANCE.getBestMeal("ketchup"), KETCHUP);
        HFIngredients.registerForOre("foodButter", BUTTER);
        HFIngredients.registerForOre("foodScrambledegg", SCRAMBLED_EGG);
        HFIngredients.registerForOre("foodKetchup", KETCHUP);
        CookingAPI.INSTANCE.register(HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.SASHIMI), SASHIMI);
        CookingAPI.INSTANCE.register(HFCooking.INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.COOKIES), COOKIES);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151025_P), BREAD);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151168_bH), BAKED_POTATO);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151115_aP, 1, 0), COD);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151115_aP, 1, 1), SALMON);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151076_bf), CHICKEN);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_179558_bo), RABBIT);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151082_bd), BEEF);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151147_al), PORK);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_179561_bm), MUTTON);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_179559_bp), RABBIT_COOKED);
        HFIngredients.registerForOre("foodSalt", SALT);
        CookingAPI.INSTANCE.register(new ItemStack(Items.field_151102_aT), SUGAR);
    }

    private static void registerForOre(String ore, Ingredient ingredient) {
        for (ItemStack item : OreDictionary.getOres((String)ore)) {
            CookingAPI.INSTANCE.register(item, ingredient);
        }
    }
}

