/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.item;

import java.util.List;
import joshie.harvest.api.cooking.IAltItem;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.recipe.HFRecipes;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFFoodFML;
import joshie.harvest.core.util.Text;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeal
extends ItemHFFoodFML<ItemMeal, MealImpl>
implements IAltItem,
IShippable {
    public ItemMeal() {
        super(CookingAPI.REGISTRY, HFTab.COOKING);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        MealImpl impl = stack.func_77942_o() ? (MealImpl)CookingAPI.REGISTRY.getValues().get(Math.max(0, Math.min(CookingAPI.REGISTRY.getValues().size(), stack.func_77952_i()))) : null;
        return impl != null ? impl.getDisplayName() : TextFormatting.DARK_GRAY + Text.localize(Utensil.getUtensilFromIndex(stack.func_77952_i()).getUnlocalizedName());
    }

    public int func_150905_g(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("FoodLevel") : 0;
    }

    public float func_150906_h(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74760_g("FoodSaturation") : 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        if (debug && HFCore.DEBUG_MODE && stack.func_77942_o()) {
            list.add(Text.translate("meal.hunger") + " : " + stack.func_77978_p().func_74762_e("FoodLevel"));
            list.add(Text.translate("meal.sat") + " : " + stack.func_77978_p().func_74760_g("FoodSaturation"));
            list.add(Text.translate("meal.exhaust") + " : " + stack.func_77978_p().func_74762_e("FoodExhaustion"));
            list.add(Text.translate("meal.sell") + " : " + stack.func_77978_p().func_74763_f("SellValue"));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (stack.func_77942_o() && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            float exhaustion = stack.func_77978_p().func_74760_g("FoodExhaustion");
            player.func_71024_bL().func_151686_a((ItemFood)this, stack);
            player.func_71024_bL().func_75113_a(exhaustion);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return stack;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("EatTime");
        }
        return super.func_77626_a(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("IsDrink") ? EnumAction.DRINK : EnumAction.EAT;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_71043_e(false)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public MealImpl getNullValue() {
        return HFRecipes.NULL_RECIPE;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0L;
        }
        return stack.func_77978_p().func_74763_f("SellValue");
    }

    @Override
    public ItemStack getCreativeStack(Item item, MealImpl recipe) {
        return recipe.cook(recipe.getBestMeal());
    }

    @Override
    public ItemStack getStackFromObject(MealImpl recipe) {
        return this.getCreativeStack((Item)this, recipe);
    }

    @Override
    public ItemStack getStackFromResource(ResourceLocation resource) {
        return this.getStackFromObject((MealImpl)this.registry.getValue(resource));
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 100;
    }

    @Override
    public ItemStack getAlternativeWhenCooking(ItemStack stack) {
        int id = Math.max(0, Math.min(CookingAPI.REGISTRY.getValues().size() - 1, stack.func_77952_i()));
        MealImpl recipe = (MealImpl)CookingAPI.REGISTRY.getValues().get(id);
        if (recipe != null) {
            return recipe.getAlternativeItem();
        }
        return null;
    }
}

