/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.item;

import java.util.List;
import joshie.harvest.HarvestFestival;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.cooking.tile.TileCooking;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.item.ItemHFBase;
import joshie.harvest.core.util.ICreativeSorted;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemCookbook
extends ItemHFBase<ItemCookbook>
implements ICreativeSorted {
    public ItemCookbook() {
        super(HFTab.COOKING);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            player.openGui((Object)HarvestFestival.instance, 7, world, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 1000;
    }

    private static boolean isIngredient(Ingredient ingredient, List<Ingredient> set) {
        for (Ingredient check : set) {
            if (!ingredient.isEqual(check)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack getAndRemoveIngredient(Ingredient ingredient, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !ItemCookbook.isIngredient(ingredient, CookingAPI.INSTANCE.getCookingComponents(stack))) continue;
            ItemStack ret = stack.func_77979_a(1);
            if (stack.field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[i] = null;
            }
            return ret;
        }
        return null;
    }

    public static boolean cook(TileCooking cooking, EntityPlayer player, MealImpl selected) {
        if (selected != null) {
            if (!CookingHelper.hasAllIngredients(selected, player)) {
                return false;
            }
            for (Ingredient ingredient : selected.getRequiredIngredients()) {
                ItemStack ret = ItemCookbook.getAndRemoveIngredient(ingredient, player);
                if (ret == null) {
                    return false;
                }
                cooking.addIngredient(ret);
            }
            return true;
        }
        return false;
    }
}

