/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.block.BlockCookware;
import joshie.harvest.cooking.gui.GuiCookbook;
import joshie.harvest.cooking.gui.Page;
import joshie.harvest.cooking.gui.PageRecipe;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.core.handlers.HFTrackers;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class PageRecipeList
extends Page {
    private static final HashMap<Utensil, PageRecipeList> UTENSIL_PAGES = new HashMap();
    private static final HashMap<Utensil, ItemStack> RENDER_MAP = new HashMap();
    private List<PageRecipe> recipes;
    private final Utensil utensil;

    public static PageRecipeList get(Utensil utensil) {
        return UTENSIL_PAGES.get(utensil);
    }

    private PageRecipeList(Utensil utensil) {
        this.utensil = utensil;
    }

    @Override
    public PageRecipeList initGui(GuiCookbook gui) {
        super.initGui(gui);
        this.recipes = new ArrayList<PageRecipe>();
        for (ResourceLocation resource : HFTrackers.getClientPlayerTracker().getTracking().getLearntRecipes()) {
            MealImpl recipe = (MealImpl)CookingAPI.REGISTRY.getValue(resource);
            if (recipe.getRequiredTool() != this.utensil) continue;
            this.recipes.add(PageRecipe.of(recipe));
        }
        return this;
    }

    @Override
    public Page getOwner() {
        return GuiCookbook.MASTER;
    }

    @Override
    public Utensil getUtensil() {
        return this.utensil;
    }

    public ItemStack getItem() {
        return RENDER_MAP.get(this.utensil);
    }

    public boolean hasRecipes() {
        return this.recipes.size() > 0;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        PageRecipe recipe;
        boolean hoverX;
        int maxLeft = Math.min(10, this.recipes.size());
        if (maxLeft > 0) {
            hoverX = mouseX >= 25 && mouseX <= 135;
            for (int i = 0; i < maxLeft; ++i) {
                boolean hoverY;
                recipe = this.recipes.get(i);
                boolean bl = hoverY = mouseY >= 22 + i * 14 && mouseY <= 35 + i * 14;
                if (hoverX && hoverY) {
                    this.gui.drawString(45, 24 + i * 14, TextFormatting.ITALIC + recipe.getRecipeName());
                } else {
                    this.gui.drawString(45, 24 + i * 14, recipe.getRecipeName());
                }
                this.gui.drawStack(25, 20 + i * 14, recipe.getItem(), 1.0f);
            }
        }
        if (maxLeft == 10 && this.recipes.size() > 10) {
            hoverX = mouseX >= 170 && mouseX <= 285;
            for (int j = 10; j < this.recipes.size(); ++j) {
                boolean hoverY;
                recipe = this.recipes.get(j);
                int i = j - 10;
                boolean bl = hoverY = mouseY >= 22 + i * 14 && mouseY <= 35 + i * 14;
                if (hoverX && hoverY) {
                    this.gui.drawString(190, 24 + i * 14, TextFormatting.ITALIC + recipe.getRecipeName());
                } else {
                    this.gui.drawString(190, 24 + i * 14, recipe.getRecipeName());
                }
                this.gui.drawStack(170, 20 + i * 14, recipe.getItem(), 1.0f);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY) {
        boolean hoverX;
        int maxLeft = Math.min(10, this.recipes.size());
        if (maxLeft > 0) {
            hoverX = mouseX >= 25 && mouseX <= 135;
            for (int i = 0; i < maxLeft; ++i) {
                boolean hoverY;
                boolean bl = hoverY = mouseY >= 22 + i * 14 && mouseY <= 35 + i * 14;
                if (!hoverX || !hoverY) continue;
                return this.gui.setPage(this.recipes.get(i));
            }
        }
        if (maxLeft == 10 && this.recipes.size() > 10) {
            hoverX = mouseX >= 170 && mouseX <= 285;
            for (int j = 10; j < this.recipes.size(); ++j) {
                boolean hoverY;
                int i = j - 10;
                boolean bl = hoverY = mouseY >= 22 + i * 14 && mouseY <= 35 + i * 14;
                if (!hoverX || !hoverY) continue;
                return this.gui.setPage(this.recipes.get(j));
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRecipeList that = (PageRecipeList)o;
        return this.utensil == that.utensil;
    }

    public int hashCode() {
        return this.utensil != null ? this.utensil.hashCode() : 0;
    }

    static {
        RENDER_MAP.put(Utensil.COUNTER, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.COUNTER));
        RENDER_MAP.put(Utensil.FRYING_PAN, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.FRYING_PAN));
        RENDER_MAP.put(Utensil.MIXER, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.MIXER));
        RENDER_MAP.put(Utensil.OVEN, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.OVEN_ON));
        RENDER_MAP.put(Utensil.POT, HFCooking.COOKWARE.getStackFromEnum(BlockCookware.Cookware.POT));
        for (int i = 0; i < 5; ++i) {
            Utensil utensil = Utensil.getUtensilFromIndex(i);
            UTENSIL_PAGES.put(utensil, new PageRecipeList(utensil));
        }
    }
}

