/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.CookingHelper;
import joshie.harvest.cooking.gui.GuiCookbook;
import joshie.harvest.cooking.gui.Page;
import joshie.harvest.cooking.gui.PageRecipeList;
import joshie.harvest.cooking.packet.PacketSelectRecipe;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.util.Text;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class PageRecipe
extends Page {
    private static final HashMap<MealImpl, PageRecipe> recipeMap = new HashMap();
    private final MealImpl recipe;
    private final List<CyclingStack> list = new ArrayList<CyclingStack>();
    private final ItemStack stack;
    private final String description;

    public static PageRecipe of(MealImpl recipe) {
        return recipeMap.get(recipe);
    }

    public PageRecipe(MealImpl recipe) {
        this.recipe = recipe;
        this.stack = recipe.cook(recipe.getMeal());
        this.description = recipe.getRegistryName().func_110624_b() + ".meal." + recipe.getRegistryName().func_110623_a().replace("_", ".") + ".description";
    }

    @Override
    public Page getOwner() {
        return PageRecipeList.get(this.recipe.getRequiredTool());
    }

    public String getRecipeName() {
        return this.recipe.getDisplayName();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    @Override
    public Utensil getUtensil() {
        return this.recipe.getRequiredTool();
    }

    @Override
    public PageRecipe initGui(GuiCookbook gui) {
        super.initGui(gui);
        this.list.clear();
        int x = 165;
        for (int y = 0; y < this.recipe.getRequiredIngredients().length; ++y) {
            this.list.add(new CyclingStack(x, 35 + y * 16, this.recipe.getRequiredIngredients()[y]));
        }
        return this;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int left = (36 - this.getRecipeName().length()) * 2;
        ItemStack stack = this.getItem();
        this.gui.drawString(left, 20, TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + this.getRecipeName());
        this.gui.drawBox(25, 30, 110, 1, -5200765);
        this.gui.drawBox(26, 31, 110, 1, -6517661);
        this.gui.drawString(60, 35, TextFormatting.BOLD + Text.translate("meal.hunger"));
        this.gui.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/icons.png"));
        int hunger = stack.func_77978_p().func_74762_e("FoodLevel");
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < hunger; ++i) {
            if (i % 2 == 0) {
                this.gui.drawTexture(i * 4 + 58, 46, 16, 27, 9, 9);
            }
            if (i + 1 < hunger && i % 2 == 0) {
                this.gui.drawTexture(i * 4 + 58, 46, 52, 27, 9, 9);
                continue;
            }
            if (i % 2 != 0) continue;
            this.gui.drawTexture(i * 4 + 58, 46, 61, 27, 9, 9);
        }
        this.gui.drawBox(25, 60, 110, 1, -5200765);
        this.gui.drawBox(26, 61, 110, 1, -6517661);
        this.gui.drawString(25, 65, TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + Text.translate("meal.description"));
        this.gui.drawString(25, 78, Text.localize(this.description));
        this.gui.drawStack(22, 30, this.getItem(), 2.0f);
        GlStateManager.func_179141_d();
        this.gui.drawString(190, 20, TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + Text.translate("meal.recipe"));
        this.gui.drawBox(170, 30, 110, 1, -5200765);
        this.gui.drawBox(171, 31, 110, 1, -6517661);
        GlStateManager.func_179097_i();
        for (CyclingStack cycling : this.list) {
            cycling.render(this.gui, mouseX, mouseY);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.field_146297_k.func_110434_K().func_110577_a(GuiCookbook.LEFT_GUI);
        int y = mouseX >= 236 && mouseX <= 287 && mouseY >= 148 && mouseY <= 176 ? 129 : 101;
        this.gui.drawTexture(236, 148, 0, y, 51, 28);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY) {
        if (mouseX >= 236 && mouseX <= 287 && mouseY >= 148 && mouseY <= 176) {
            if (CookingHelper.hasAllIngredients(this.recipe, GuiCookbook.ingredients)) {
                String utensil = TextFormatting.YELLOW + PageRecipeList.get(this.recipe.getRequiredTool()).getItem().func_82833_r() + TextFormatting.RESET;
                String name = TextFormatting.YELLOW + this.recipe.getDisplayName() + TextFormatting.RESET;
                CookingHelper.PlaceIngredientResult result = CookingHelper.tryPlaceIngredients((EntityPlayer)MCClientHelper.getPlayer(), this.recipe);
                if (result == CookingHelper.PlaceIngredientResult.SUCCESS) {
                    PacketHandler.sendToServer(new PacketSelectRecipe(this.recipe));
                    MCClientHelper.getPlayer().func_71053_j();
                    ChatHelper.displayChat(TextFormatting.GREEN + Text.translate("meal.success") + TextFormatting.WHITE + " " + Text.format("harvestfestival.meal.success.description", utensil, name));
                } else {
                    ChatHelper.displayChat(TextFormatting.RED + Text.translate("meal." + result.name().toLowerCase(Locale.ENGLISH)) + TextFormatting.WHITE + "\n " + Text.format("harvestfestival.meal." + result.name().toLowerCase(Locale.ENGLISH) + ".description", utensil, name));
                }
            } else {
                ChatHelper.displayChat(TextFormatting.RED + Text.translate("meal.missing") + TextFormatting.WHITE + " " + Text.translate("meal.missing.description"));
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRecipe that = (PageRecipe)o;
        return this.recipe != null ? this.recipe.equals(that.recipe) : that.recipe == null;
    }

    public int hashCode() {
        return this.recipe != null ? this.recipe.hashCode() : 0;
    }

    static {
        recipeMap.clear();
        for (MealImpl recipe : CookingAPI.REGISTRY) {
            recipeMap.put(recipe, new PageRecipe(recipe));
        }
    }

    public static class CyclingStack {
        private final int x;
        private final int y;
        private final Ingredient ingredient;
        private List<ItemStack> stacks;
        private ItemStack stack;
        private int ticker;
        private int index;

        public CyclingStack(int x, int y, Ingredient ingredient) {
            this.x = x;
            this.y = y;
            this.stacks = CookingAPI.INSTANCE.getStacksForIngredient(ingredient);
            this.ingredient = ingredient;
        }

        public void render(GuiCookbook gui, int mouseX, int mouseY) {
            if (this.stacks.size() > 0) {
                if (this.ticker % 128 == 0 || this.stack == null) {
                    this.stack = this.stacks.get(this.index);
                    ++this.index;
                    if (this.index >= this.stacks.size()) {
                        this.index = 0;
                    }
                }
                gui.drawStack(this.x, this.y, this.stack, 1.0f);
                boolean isInInventory = CookingHelper.hasIngredientInInventory(GuiCookbook.ingredients, this.ingredient);
                TextFormatting formatting = isInInventory ? TextFormatting.DARK_GREEN : TextFormatting.RED;
                gui.drawString(this.x + 20, this.y + 6, formatting + this.stack.func_82833_r());
                GlStateManager.func_179097_i();
                gui.field_146297_k.func_110434_K().func_110577_a(GuiCookbook.LEFT_GUI);
                if (isInInventory) {
                    gui.drawTexture(this.x + 8, this.y + 10, 31, 248, 10, 8);
                } else {
                    gui.drawTexture(this.x + 9, this.y + 10, 41, 248, 7, 8);
                }
                if (mouseX >= this.x && mouseX <= this.x + 16 && mouseY >= this.y && mouseY < this.y + 16) {
                    gui.addRunnable(() -> gui.drawIngredientTooltip(this.stacks, mouseX, mouseY));
                } else {
                    ++this.ticker;
                }
                GlStateManager.func_179126_j();
            } else {
                this.stacks = CookingAPI.INSTANCE.getStacksForIngredient(this.ingredient);
            }
        }
    }
}

