/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking.block;

import java.util.Locale;
import joshie.harvest.HarvestFestival;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.tile.TileCooking;
import joshie.harvest.cooking.tile.TileCounter;
import joshie.harvest.cooking.tile.TileFridge;
import joshie.harvest.cooking.tile.TileFryingPan;
import joshie.harvest.cooking.tile.TileHeatable;
import joshie.harvest.cooking.tile.TileMixer;
import joshie.harvest.cooking.tile.TileOven;
import joshie.harvest.cooking.tile.TilePot;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnumRotatableTile;
import joshie.harvest.core.util.IFaceable;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCookware
extends BlockHFEnumRotatableTile<BlockCookware, Cookware> {
    private static final AxisAlignedBB FRYING_PAN_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.15f, (double)0.8f);
    private static final AxisAlignedBB MIXER_AABB = new AxisAlignedBB((double)0.275f, 0.0, (double)0.275f, (double)0.725f, (double)0.725f, (double)0.725f);
    private static final AxisAlignedBB POT_AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.375, (double)0.8f);
    private static Item cookware = null;

    public BlockCookware() {
        super(Material.field_76233_E, Cookware.class, HFTab.COOKING);
        this.setHardness(2.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{temporary, FACING});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        return cookware != Cookware.FRIDGE_TOP && (cookware == Cookware.MIXER ? layer == BlockRenderLayer.TRANSLUCENT : layer == BlockRenderLayer.CUTOUT_MIPPED);
    }

    @Override
    public String getToolType(Cookware cookware) {
        return cookware == Cookware.COUNTER ? "axe" : "pickaxe";
    }

    public Material func_149688_o(IBlockState state) {
        return this.getEnumFromState(state) == Cookware.COUNTER ? Material.field_151575_d : super.func_149688_o(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.getEnumFromState(state) == Cookware.FRIDGE) {
            AxisAlignedBB axisalignedbb = state.func_185900_c(world, pos);
            switch (side) {
                case DOWN: {
                    if (!(axisalignedbb.field_72338_b > 0.0)) break;
                    return true;
                }
                case UP: {
                    if (!(axisalignedbb.field_72337_e < 1.0)) break;
                    return true;
                }
                case NORTH: {
                    if (!(axisalignedbb.field_72339_c > 0.0)) break;
                    return true;
                }
                case SOUTH: {
                    if (!(axisalignedbb.field_72334_f < 1.0)) break;
                    return true;
                }
                case WEST: {
                    if (!(axisalignedbb.field_72340_a > 0.0)) break;
                    return true;
                }
                case EAST: {
                    if (!(axisalignedbb.field_72336_d < 1.0)) break;
                    return true;
                }
            }
            return !world.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(world, pos.func_177972_a(side), side.func_176734_d()) || !world.func_180495_p(pos.func_177972_a(side).func_177984_a()).doesSideBlockRendering(world, pos.func_177972_a(side).func_177984_a(), side.func_176734_d());
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        switch (cookware) {
            case FRYING_PAN: {
                return FRYING_PAN_AABB;
            }
            case POT: {
                return POT_AABB;
            }
            case FRIDGE: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
            }
            case FRIDGE_TOP: {
                return new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
            }
            case MIXER: {
                return MIXER_AABB;
            }
        }
        return field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        if (player.func_70093_af()) {
            return false;
        }
        if (cookware == Cookware.FRIDGE || cookware == Cookware.FRIDGE_TOP) {
            TileFridge fridge;
            int y;
            int n = y = cookware == Cookware.FRIDGE_TOP ? pos.func_177956_o() - 1 : pos.func_177956_o();
            if (world.field_72995_K && (fridge = (TileFridge)world.func_175625_s(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()))) != null) {
                if (cookware == Cookware.FRIDGE_TOP) {
                    fridge.animatingTop = true;
                } else if (cookware == Cookware.FRIDGE) {
                    fridge.animatingBottom = true;
                }
            }
            player.openGui((Object)HarvestFestival.instance, 3, world, pos.func_177958_n(), y, pos.func_177952_p());
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCooking) {
            TileCooking cooking = (TileCooking)tile;
            if (!cooking.isFinishedCooking()) {
                cooking.giveToPlayer(player);
                return true;
            }
            if (held != null) {
                if (ToolHelper.isKnife(held)) {
                    if (cookware == Cookware.COUNTER || world.func_175625_s(pos.func_177977_b()) instanceof TileCounter) {
                        TileCooking tileCooking = cooking = cookware == Cookware.COUNTER ? cooking : (TileCooking)world.func_175625_s(pos.func_177977_b());
                        if (cooking != null) {
                            cooking.update();
                            return true;
                        }
                    }
                    return false;
                }
                if (!BlockCookware.isCookware(held) && cooking.addIngredient(held)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    return true;
                }
            } else {
                cooking.takeBackLastStack(player);
            }
        }
        return false;
    }

    public static boolean isCookware(ItemStack stack) {
        if (cookware == null) {
            cookware = Item.func_150898_a((Block)HFCooking.COOKWARE);
        }
        return stack.func_77973_b() == cookware;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFridge) {
            world.func_180501_a(pos.func_177984_a(), this.getStateFromEnum(Cookware.FRIDGE_TOP), 2);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        try {
            Cookware cookware = (Cookware)((Object)this.getEnumFromBlockPos((IBlockAccess)world, pos));
            if (cookware == Cookware.FRIDGE_TOP) {
                world.func_175698_g(pos.func_177977_b());
            } else if (cookware == Cookware.FRIDGE) {
                world.func_175698_g(pos.func_177984_a());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        if (cookware == Cookware.FRIDGE_TOP) {
            world.func_175698_g(pos.func_177977_b());
        } else if (cookware == Cookware.FRIDGE) {
            world.func_175698_g(pos.func_177984_a());
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileCooking) {
            TileCooking cooking = (TileCooking)tileentity;
            for (ItemStack stack : cooking.getIngredients()) {
                if (stack == null) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
            if (cooking.getResult() != null) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)cooking.getResult());
            }
            world.func_175666_e(pos, (Block)this);
        } else if (tileentity instanceof TileFridge) {
            TileFridge fridge = (TileFridge)tileentity;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)fridge.getContents());
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.getEnumFromState(state) == Cookware.FRIDGE_TOP ? Cookware.FRIDGE.ordinal() : super.func_180651_a(state);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return this.getEnumFromState(state) != Cookware.FRIDGE_TOP;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState ret = super.func_176221_a(state, world, pos);
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(ret));
        if (cookware == Cookware.OVEN_OFF || cookware == Cookware.OVEN_ON) {
            TileEntity tile = world.func_175625_s(pos.func_177984_a());
            if (tile instanceof TileHeatable && ((TileHeatable)tile).isCooking()) {
                return ret.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.OVEN_ON));
            }
            return ret.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.OVEN_OFF));
        }
        if (cookware == Cookware.COUNTER) {
            EnumFacing northFacing = this.getFacing(EnumFacing.NORTH, world, pos);
            EnumFacing eastFacing = this.getFacing(EnumFacing.EAST, world, pos);
            EnumFacing southFacing = this.getFacing(EnumFacing.SOUTH, world, pos);
            EnumFacing westFacing = this.getFacing(EnumFacing.WEST, world, pos);
            if (northFacing == EnumFacing.WEST && westFacing == EnumFacing.NORTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_IC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            if (southFacing == EnumFacing.WEST && westFacing == EnumFacing.SOUTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_IC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            if (southFacing == EnumFacing.EAST && eastFacing == EnumFacing.SOUTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_IC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            if (northFacing == EnumFacing.EAST && eastFacing == EnumFacing.NORTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_IC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            if (northFacing == EnumFacing.EAST && westFacing == EnumFacing.SOUTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_OC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            if (southFacing == EnumFacing.EAST && westFacing == EnumFacing.NORTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_OC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            if (southFacing == EnumFacing.WEST && eastFacing == EnumFacing.NORTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_OC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            if (northFacing == EnumFacing.WEST && eastFacing == EnumFacing.SOUTH) {
                return state.func_177226_a((IProperty)this.property, (Comparable)((Object)Cookware.COUNTER_OC)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
        }
        return ret;
    }

    public EnumFacing getFacing(EnumFacing facing, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
        if (tile instanceof TileCounter || tile instanceof TileOven || tile instanceof TileFridge) {
            return ((IFaceable)tile).getFacing();
        }
        return EnumFacing.DOWN;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        Cookware cookware = (Cookware)((Object)this.getEnumFromState(state));
        switch (cookware) {
            case FRIDGE: {
                return new TileFridge();
            }
            case COUNTER: {
                return new TileCounter();
            }
            case POT: {
                return new TilePot();
            }
            case FRYING_PAN: {
                return new TileFryingPan();
            }
            case MIXER: {
                return new TileMixer();
            }
            case OVEN_OFF: {
                return new TileOven();
            }
            case OVEN_ON: {
                return new TileOven();
            }
        }
        return null;
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 99;
    }

    @Override
    protected boolean shouldDisplayInCreative(Cookware cookware) {
        return cookware.isReal;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((Cookware[])this.values).length; ++i) {
            if (((Cookware[])this.values)[i] == Cookware.FRIDGE || ((Cookware[])this.values)[i] == Cookware.FRIDGE_TOP) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_fridge"));
                continue;
            }
            if (((Cookware[])this.values)[i] == Cookware.OVEN_ON || ((Cookware[])this.values)[i] == Cookware.OVEN_OFF) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_oven"));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), this.property.func_177701_a() + "=" + ((Cookware)((Object)this.getEnumFromMeta(i))).func_176610_l() + ",facing=north"));
        }
    }

    public static enum Cookware implements IStringSerializable
    {
        FRIDGE_TOP(false),
        FRIDGE(true),
        COUNTER(true),
        POT(true),
        FRYING_PAN(true),
        MIXER(true),
        OVEN_OFF(true),
        OVEN_ON(false),
        COUNTER_IC(false),
        COUNTER_OC(false);

        private final boolean isReal;

        private Cookware(boolean isReal) {
            this.isReal = isReal;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

