/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.cooking.ICookingComponent;
import joshie.harvest.api.cooking.IMeal;
import joshie.harvest.api.cooking.IMealRecipe;
import joshie.harvest.api.cooking.IUtensil;
import joshie.harvest.cooking.Meal;
import net.minecraft.item.ItemStack;

public class Recipe
implements IMealRecipe {
    public final IMeal result;
    private final ICookingComponent[] requiredIngredients;
    private IUtensil requiredTool;
    private ICookingComponent[] optionalIngredients;

    public Recipe(ICookingComponent[] ingredients, IMeal result) {
        this.requiredIngredients = ingredients;
        this.result = result;
    }

    @Override
    public IMealRecipe setOptionalIngredients(ICookingComponent ... ingredients) {
        this.optionalIngredients = ingredients;
        return this;
    }

    @Override
    public IMealRecipe setRequiredTool(IUtensil tool) {
        this.requiredTool = tool;
        return this;
    }

    @Override
    public IMealRecipe setIsDrink() {
        this.result.setIsDrink();
        return this;
    }

    @Override
    public IMealRecipe setAlternativeTexture(ItemStack stack) {
        this.result.setAlternativeItem(stack);
        return this;
    }

    private boolean recipeHasThisIngredient(ICookingComponent ingredient) {
        for (ICookingComponent i : this.requiredIngredients) {
            if (!i.isEqual(ingredient)) continue;
            return true;
        }
        if (this.optionalIngredients != null) {
            for (ICookingComponent i : this.optionalIngredients) {
                if (!i.isEqual(ingredient)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ingredientListContains(Set<ICookingComponent> ingredients, ICookingComponent required) {
        for (ICookingComponent passed : ingredients) {
            if (!required.isEqual(passed)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMeal getMeal(IUtensil utensil, HashSet<ICookingComponent> ingredients) {
        if (ingredients == null || ingredients.size() < 1 || utensil != this.requiredTool) {
            return null;
        }
        for (ICookingComponent ingredient : ingredients) {
            if (this.recipeHasThisIngredient(ingredient)) continue;
            return null;
        }
        for (ICookingComponent required : this.requiredIngredients) {
            if (this.ingredientListContains(ingredients, required)) continue;
            return null;
        }
        Meal meal = new Meal(this.result);
        if (this.optionalIngredients != null) {
            for (ICookingComponent optional : this.optionalIngredients) {
                if (!this.ingredientListContains(ingredients, optional)) continue;
                meal.addIngredient(optional);
            }
        }
        return meal;
    }

    @Override
    public IMeal getMeal() {
        return new Meal(this.result);
    }

    @Override
    public IMeal getBestMeal() {
        IMeal meal = this.getMeal();
        if (this.optionalIngredients != null) {
            for (ICookingComponent i : this.optionalIngredients) {
                meal.addIngredient(i);
            }
        }
        return meal;
    }
}

