/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import joshie.harvest.api.cooking.ICookingComponent;
import joshie.harvest.api.cooking.IMeal;
import joshie.harvest.items.HFItems;
import joshie.harvest.items.ItemMeal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Meal
implements IMeal {
    static final ItemStack BURNT = new ItemStack(HFItems.MEAL);
    private static double hunger_modifier = 1.0;
    private static double saturation_modifier = 1.0;
    public ResourceLocation resource;
    public String unlocalized;
    public int stamina = 0;
    public int fatigue = 0;
    public int hunger = 0;
    public float saturation = 0.0f;
    public int eatTime = 32;
    public boolean isLiquid = false;
    public ItemStack alt = null;
    public int hunger_cap = 20;
    public float saturation_cap = 2.0f;

    public Meal(String unlocalized, int stamina, int fatigue, int hunger, float saturation, int eatTime) {
        this.unlocalized = unlocalized;
        this.stamina = stamina;
        this.fatigue = fatigue;
        this.hunger = (int)((double)hunger * hunger_modifier);
        this.saturation = (float)((double)saturation * saturation_modifier);
        this.eatTime = eatTime;
        this.resource = new ResourceLocation("harvestfestival", "meals/" + unlocalized.replace(".", "_"));
    }

    public Meal(IMeal meal) {
        this.unlocalized = meal.getUnlocalizedName();
        this.stamina = meal.getStamina();
        this.fatigue = meal.getFatigue();
        this.hunger = meal.getHunger();
        this.saturation = meal.getSaturation();
        this.eatTime = meal.getEatTime();
        this.isLiquid = meal.isDrink();
        this.alt = meal.getAlternativeItem();
        this.hunger_cap = meal.getHungerCap();
        this.saturation_cap = meal.getSaturationCap();
        this.resource = meal.getResource();
    }

    @Override
    public IMeal setIsDrink() {
        this.isLiquid = true;
        return this;
    }

    @Override
    public IMeal setResourceLocation(ResourceLocation resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public IMeal setAlternativeItem(ItemStack alt) {
        this.alt = alt;
        return this;
    }

    @Override
    public ItemStack getAlternativeItem() {
        return this.alt;
    }

    @Override
    public ResourceLocation getResource() {
        return this.resource;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalized;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public int getStamina() {
        return this.stamina;
    }

    @Override
    public int getFatigue() {
        return this.fatigue;
    }

    @Override
    public boolean isDrink() {
        return this.isLiquid;
    }

    @Override
    public int getEatTime() {
        return this.eatTime;
    }

    @Override
    public int getHungerCap() {
        return this.hunger_cap;
    }

    @Override
    public float getSaturationCap() {
        return this.saturation_cap;
    }

    @Override
    public IMeal addIngredient(ICookingComponent ingredient) {
        this.eatTime += ingredient.getEatTime();
        this.stamina += ingredient.getStamina();
        this.fatigue += ingredient.getFatigue();
        this.hunger += ingredient.getHunger();
        this.saturation += ingredient.getSaturation();
        this.hunger = Math.min(this.hunger_cap, this.hunger);
        this.saturation = Math.min(this.saturation_cap, this.saturation);
        return this;
    }

    @Override
    public ItemStack cook(IMeal meal) {
        return ItemMeal.cook(new ItemStack(HFItems.MEAL), meal);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IMeal)) {
            return false;
        }
        return this.getUnlocalizedName().equals(((IMeal)o).getUnlocalizedName());
    }

    public int hashCode() {
        return this.unlocalized.hashCode();
    }
}

