/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import java.util.HashSet;
import joshie.harvest.api.cooking.ICookingComponent;
import net.minecraft.util.ResourceLocation;

public class Ingredient
implements ICookingComponent {
    private HashSet<Ingredient> equivalents = new HashSet();
    private String unlocalized;
    public int stamina;
    public int fatigue;
    public int hunger;
    public float saturation;
    public int eatTime;
    public ResourceLocation fluid;

    public Ingredient(String unlocalized, int stamina, int fatigue, int hunger, float saturation, int eatTime) {
        this.unlocalized = unlocalized;
        this.stamina = stamina;
        this.fatigue = fatigue;
        this.hunger = hunger;
        this.saturation = saturation;
        this.eatTime = eatTime;
        this.equivalents.add(this);
    }

    public Ingredient(String unlocalized) {
        this.unlocalized = unlocalized;
        this.equivalents.add(this);
    }

    @Override
    public ICookingComponent add(ICookingComponent ... components) {
        for (ICookingComponent component : components) {
            this.equivalents.add((Ingredient)component);
        }
        return this;
    }

    @Override
    public ICookingComponent assign(ICookingComponent ... ingredient) {
        for (ICookingComponent c : ingredient) {
            c.add(this);
        }
        return this;
    }

    @Override
    public ICookingComponent setFluid(ResourceLocation fluid) {
        this.fluid = fluid;
        return this;
    }

    @Override
    public ResourceLocation getFluid() {
        return this.fluid;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalized;
    }

    @Override
    public int getEatTime() {
        return this.eatTime;
    }

    @Override
    public int getStamina() {
        return this.stamina;
    }

    @Override
    public int getFatigue() {
        return this.fatigue;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public boolean isEqual(ICookingComponent ingredient) {
        for (Ingredient i : this.equivalents) {
            if (!i.getUnlocalizedName().equals(ingredient.getUnlocalizedName())) continue;
            return true;
        }
        return false;
    }
}

