/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import joshie.harvest.api.HFApi;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.block.BlockCookware;
import joshie.harvest.cooking.item.ItemCookbook;
import joshie.harvest.cooking.item.ItemIngredients;
import joshie.harvest.cooking.item.ItemMeal;
import joshie.harvest.cooking.item.ItemRecipe;
import joshie.harvest.cooking.item.ItemUtensil;
import joshie.harvest.cooking.recipe.RecipeMayo;
import joshie.harvest.cooking.recipe.RecipeMeal;
import joshie.harvest.cooking.recipe.RecipeStack;
import joshie.harvest.cooking.render.MealDefinition;
import joshie.harvest.cooking.render.SpecialRendererCounter;
import joshie.harvest.cooking.render.SpecialRendererFridge;
import joshie.harvest.cooking.render.SpecialRendererFryingPan;
import joshie.harvest.cooking.render.SpecialRendererMixer;
import joshie.harvest.cooking.render.SpecialRendererOven;
import joshie.harvest.cooking.render.SpecialRendererPot;
import joshie.harvest.cooking.tile.TileCounter;
import joshie.harvest.cooking.tile.TileFridge;
import joshie.harvest.cooking.tile.TileFryingPan;
import joshie.harvest.cooking.tile.TileMixer;
import joshie.harvest.cooking.tile.TileOven;
import joshie.harvest.cooking.tile.TilePot;
import joshie.harvest.core.base.FMLDefinition;
import joshie.harvest.core.base.MeshIdentical;
import joshie.harvest.core.helpers.RegistryHelper;
import joshie.harvest.core.util.HFLoader;
import joshie.harvest.core.util.IFMLItem;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@HFLoader(priority=7)
public class HFCooking {
    public static final BlockCookware COOKWARE = (BlockCookware)((Object)new BlockCookware().register("cookware"));
    public static final ItemMeal MEAL = (ItemMeal)new ItemMeal().register("meal");
    public static final ItemRecipe RECIPE = (ItemRecipe)new ItemRecipe().register("recipe");
    public static final ItemCookbook COOKBOOK = (ItemCookbook)new ItemCookbook().register("cookbook");
    public static final ItemUtensil UTENSILS = (ItemUtensil)new ItemUtensil().register("utensils");
    public static final ItemIngredients INGREDIENTS = (ItemIngredients)new ItemIngredients().register("ingredients");

    public static void preInit() {
        TileMixer.BLADE_STACK = UTENSILS.getStackFromEnum(ItemUtensil.Utensil.BLADE);
        HFApi.cooking.registerRecipeHandler(new RecipeMayo());
        HFApi.cooking.registerRecipeHandler(new RecipeMeal());
        HFApi.cooking.registerRecipeHandler(RecipeStack.INSTANCE);
        HFApi.cooking.registerKnife(new ItemStack((Item)UTENSILS, 1, ItemUtensil.Utensil.KNIFE.ordinal()));
        OreDictionary.registerOre((String)"foodOliveoil", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.OIL));
        OreDictionary.registerOre((String)"foodChocolatebar", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.CHOCOLATE));
        OreDictionary.registerOre((String)"foodButter", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.BUTTER));
        OreDictionary.registerOre((String)"foodFlour", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.FLOUR));
        OreDictionary.registerOre((String)"foodSalt", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.SALT));
        OreDictionary.registerOre((String)"foodKetchup", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.KETCHUP));
        OreDictionary.registerOre((String)"foodScrambledegg", (ItemStack)INGREDIENTS.getStackFromEnum(ItemIngredients.Ingredient.EGG_SCRAMBLED));
        RegistryHelper.registerSounds("counter", "fridge", "frying_pan", "mixer", "oven", "oven_done", "oven_door", "pot", "recipe");
        RegistryHelper.registerTiles(TileFridge.class, TileFryingPan.class, TileCounter.class, TileMixer.class, TileOven.class, TilePot.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelLoader.setCustomMeshDefinition((Item)MEAL, (ItemMeshDefinition)new MealDefinition((IFMLItem)MEAL, "meals", CookingAPI.REGISTRY));
        ModelLoader.setCustomMeshDefinition((Item)RECIPE, (ItemMeshDefinition)new MeshIdentical(RECIPE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileFryingPan.class, (TileEntitySpecialRenderer)new SpecialRendererFryingPan());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePot.class, (TileEntitySpecialRenderer)new SpecialRendererPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCounter.class, (TileEntitySpecialRenderer)new SpecialRendererCounter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMixer.class, (TileEntitySpecialRenderer)new SpecialRendererMixer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileOven.class, (TileEntitySpecialRenderer)new SpecialRendererOven());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFridge.class, (TileEntitySpecialRenderer)new SpecialRendererFridge());
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        FMLDefinition.getDefinition("meals").registerEverything();
    }
}

