/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import joshie.harvest.api.cooking.ICookingComponent;
import joshie.harvest.api.cooking.IFoodRegistry;
import joshie.harvest.api.cooking.IMeal;
import joshie.harvest.api.cooking.IMealRecipe;
import joshie.harvest.api.cooking.ISpecialRecipeHandler;
import joshie.harvest.api.cooking.IUtensil;
import joshie.harvest.cooking.Ingredient;
import joshie.harvest.cooking.Meal;
import joshie.harvest.cooking.Utensil;
import joshie.harvest.core.helpers.SafeStackHelper;
import joshie.harvest.core.util.SafeStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FoodRegistry
implements IFoodRegistry {
    private static final Multimap<SafeStack, ICookingComponent> registry = ArrayListMultimap.create();
    private static final HashMap<String, IMealRecipe> recipes = new HashMap(250);
    private static final HashMap<String, ICookingComponent> components = new HashMap();
    private static final HashSet<ISpecialRecipeHandler> specials = new HashSet();

    @Override
    public void register(ItemStack stack, ICookingComponent component) {
        if (stack == null || stack.func_77973_b() == null || component == null) {
            return;
        }
        registry.get((Object)SafeStackHelper.getSafeStackType(stack)).add(component);
        if (!components.containsKey(component.getUnlocalizedName())) {
            components.put(component.getUnlocalizedName(), component);
        }
    }

    @Override
    public Collection<ICookingComponent> getIngredients() {
        return components.values();
    }

    @Override
    public void registerRecipeHandler(ISpecialRecipeHandler handler) {
        specials.add(handler);
    }

    @Override
    public List<ICookingComponent> getCookingComponents(ItemStack stack) {
        return (List)SafeStackHelper.getResult(stack, registry);
    }

    @Override
    public ICookingComponent getComponent(String unlocalized) {
        return components.get(unlocalized);
    }

    @Override
    public ICookingComponent newCategory(String unlocalized) {
        return new Ingredient(unlocalized);
    }

    @Override
    public ICookingComponent newIngredient(String unlocalized, int stamina, int fatigue, int hunger, float saturation, int eatTimer) {
        return new Ingredient(unlocalized, stamina, fatigue, hunger, saturation, eatTimer);
    }

    @Override
    public ResourceLocation getFluid(ItemStack ingredient) {
        List components = (List)SafeStackHelper.getResult(ingredient, registry);
        return components.size() < 1 ? null : ((ICookingComponent)components.get(0)).getFluid();
    }

    @Override
    public IUtensil getUtensil(String unlocalized) {
        for (Utensil utensil : Utensil.values()) {
            if (!utensil.name().equalsIgnoreCase(unlocalized)) continue;
            return utensil;
        }
        return Utensil.COUNTER;
    }

    @Override
    public IMealRecipe addRecipe(IMealRecipe recipe) {
        recipes.put(recipe.getMeal().getUnlocalizedName(), recipe);
        return recipe;
    }

    @Override
    public IMealRecipe getRecipe(String meal) {
        return recipes.get(meal);
    }

    @Override
    public Collection<IMealRecipe> getRecipes() {
        return recipes.values();
    }

    @Override
    public ItemStack getBestMeal(String string) {
        for (IMealRecipe recipe : this.getRecipes()) {
            if (!recipe.getBestMeal().getUnlocalizedName().equals(string)) continue;
            return recipe.getBestMeal().cook(recipe.getBestMeal());
        }
        return null;
    }

    @Override
    public ItemStack getMeal(String string) {
        for (IMealRecipe recipe : this.getRecipes()) {
            if (!recipe.getBestMeal().getUnlocalizedName().equals(string)) continue;
            return recipe.getBestMeal().cook(recipe.getMeal());
        }
        return null;
    }

    @Override
    public ItemStack getResult(IUtensil utensil, List<ItemStack> ingredients) {
        for (ISpecialRecipeHandler iSpecialRecipeHandler : specials) {
            ItemStack ret = iSpecialRecipeHandler.getResult(utensil, ingredients);
            if (ret == null) continue;
            return ret;
        }
        HashSet<ICookingComponent> components = new HashSet<ICookingComponent>();
        for (ItemStack stack : ingredients) {
            components.addAll(this.getCookingComponents(stack));
        }
        for (IMealRecipe recipe : recipes.values()) {
            IMeal meal = recipe.getMeal(utensil, components);
            if (meal == null) continue;
            return meal.cook(meal);
        }
        ItemStack itemStack = Meal.BURNT.func_77946_l();
        itemStack.func_77964_b(utensil.ordinal());
        return itemStack;
    }
}

