/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import java.util.HashSet;
import java.util.Set;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.cooking.CookingAPI;
import joshie.harvest.cooking.HFCooking;
import joshie.harvest.cooking.item.ItemCookbook;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.cooking.tile.TileCooking;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CookingHelper {
    public static ItemStack getRecipe(String name) {
        MealImpl recipe = (MealImpl)CookingAPI.REGISTRY.getValue(new ResourceLocation("harvestfestival", name));
        return HFCooking.RECIPE.getStackFromObject(recipe);
    }

    public static boolean hasIngredientInInventory(Set<Ingredient> ingredients, Ingredient ingredient) {
        for (Ingredient inInventory : ingredients) {
            if (!ingredient.isEqual(inInventory)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllIngredients(MealImpl recipe, Set<Ingredient> ingredients) {
        for (Ingredient ingredient : recipe.getRequiredIngredients()) {
            if (CookingHelper.hasIngredientInInventory(ingredients, ingredient)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAllIngredients(MealImpl recipe, EntityPlayer player) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null) continue;
            ingredients.addAll(CookingAPI.INSTANCE.getCookingComponents(stack));
        }
        ingredients.remove(null);
        return CookingHelper.hasAllIngredients(recipe, ingredients);
    }

    public static PlaceIngredientResult tryPlaceIngredients(EntityPlayer player, MealImpl recipe) {
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos((Entity)player);
        int reach = player.field_71075_bZ.field_75098_d ? 5 : 4;
        for (int x = -reach; x <= reach; ++x) {
            for (int z = -reach; z <= reach; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    TileEntity tile = world.func_175625_s(pos.func_177982_a(x, y, z));
                    if (!(tile instanceof TileCooking)) continue;
                    TileCooking cooking = (TileCooking)tile;
                    PlaceIngredientResult result = cooking.hasPrerequisites();
                    if (result != PlaceIngredientResult.SUCCESS) {
                        return result;
                    }
                    if (cooking.getUtensil() != recipe.getRequiredTool() || cooking.getIngredients().size() != 0 || !ItemCookbook.cook(cooking, player, recipe)) continue;
                    return PlaceIngredientResult.SUCCESS;
                }
            }
        }
        return PlaceIngredientResult.FAILURE;
    }

    public static enum PlaceIngredientResult {
        SUCCESS,
        FAILURE,
        MISSING_OVEN,
        MISSING_COUNTER;

    }
}

