/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.cooking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joshie.harvest.api.cooking.CookingManager;
import joshie.harvest.api.cooking.Ingredient;
import joshie.harvest.api.cooking.RecipeHandler;
import joshie.harvest.api.cooking.Utensil;
import joshie.harvest.api.crops.ICropProvider;
import joshie.harvest.cooking.recipe.MealBuilder;
import joshie.harvest.cooking.recipe.MealImpl;
import joshie.harvest.cooking.recipe.RecipeStack;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.item.ItemSizeable;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.IFMLItem;
import joshie.harvest.core.util.holder.AbstractItemHolder;
import joshie.harvest.core.util.holder.CropHolder;
import joshie.harvest.core.util.holder.FMLHolder;
import joshie.harvest.core.util.holder.ItemHolder;
import joshie.harvest.core.util.holder.ItemStackHolder;
import joshie.harvest.core.util.holder.SizeableHolder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;

@HFApiImplementation
public class CookingAPI
implements CookingManager {
    public static final IForgeRegistry<MealImpl> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("harvestfestival", "meals")).setType(MealImpl.class).setIDRange(0, 32000).create();
    public static final CookingAPI INSTANCE = new CookingAPI();
    private final Set<RecipeHandler> handlers = new HashSet<RecipeHandler>();
    private final Multimap<AbstractItemHolder, Ingredient> registry = ArrayListMultimap.create();
    private final Multimap<Item, AbstractItemHolder> keyMap = HashMultimap.create();
    private final Set<ItemStackHolder> knives = new HashSet<ItemStackHolder>();

    private CookingAPI() {
    }

    public List<ItemStack> getStacksForIngredient(Ingredient ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Map.Entry entry : this.registry.entries()) {
            if (!ingredient.isEqual((Ingredient)entry.getValue())) continue;
            result.addAll(((AbstractItemHolder)entry.getKey()).getMatchingStacks());
        }
        return result;
    }

    public void remove(Item item) {
        this.registry.removeAll((Object)this.keyMap.get((Object)item));
        this.keyMap.removeAll((Object)item);
    }

    @Override
    public void register(ItemStack stack, Ingredient component) {
        if (stack == null || stack.func_77973_b() == null || component == null) {
            return;
        }
        AbstractItemHolder holder = this.getHolder(stack);
        this.keyMap.get((Object)stack.func_77973_b()).add(holder);
        this.registry.get((Object)holder).add(component);
    }

    private AbstractItemHolder getHolder(ItemStack stack) {
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            return ItemHolder.of(stack.func_77973_b());
        }
        if (stack.func_77973_b() instanceof ItemSizeable) {
            return SizeableHolder.of(HFCore.SIZEABLE.getObjectFromStack(stack));
        }
        if (stack.func_77973_b() instanceof ICropProvider) {
            return CropHolder.of(((ICropProvider)stack.func_77973_b()).getCrop(stack));
        }
        if (stack.func_77973_b() instanceof IFMLItem) {
            return FMLHolder.of(stack);
        }
        return ItemStackHolder.of(stack);
    }

    @Override
    public void registerKnife(ItemStack stack) {
        this.knives.add(ItemStackHolder.of(stack));
    }

    @Override
    public void registerRecipeHandler(RecipeHandler handler) {
        this.handlers.add(handler);
    }

    public List<Ingredient> getCookingComponents(ItemStack stack) {
        for (AbstractItemHolder holder : this.keyMap.get((Object)stack.func_77973_b())) {
            if (!holder.matches(stack)) continue;
            return (List)this.registry.get((Object)holder);
        }
        return new ArrayList<Ingredient>();
    }

    @Override
    public ResourceLocation getFluid(ItemStack ingredient) {
        List<Ingredient> components = this.getCookingComponents(ingredient);
        return components.size() < 1 ? null : components.get(0).getFluid();
    }

    @Override
    public MealImpl addMeal(ResourceLocation key, Utensil utensil, int hunger, float saturation, int eatTimer, Ingredient ... components) {
        String unlocalised = key.func_110624_b() + ".meal." + key.func_110623_a().replace("_", ".");
        MealImpl recipe = new MealImpl(unlocalised, utensil, components, new MealBuilder(hunger, saturation, eatTimer));
        recipe.setRegistryName(key);
        REGISTRY.register((IForgeRegistryEntry)recipe);
        return recipe;
    }

    @Override
    public void addRecipe(ItemStack output, Utensil utensil, Ingredient ... ingredients) {
        RecipeStack.INSTANCE.addRecipe(output, utensil, ingredients);
    }

    @Override
    public ItemStack getBestMeal(String string) {
        ResourceLocation location = string.contains(":") ? new ResourceLocation(string) : new ResourceLocation("harvestfestival", string);
        for (MealImpl recipe : REGISTRY.getValues()) {
            if (!recipe.getRegistryName().equals((Object)location)) continue;
            return recipe.cook(recipe.getBestMeal());
        }
        return null;
    }

    @Override
    public ItemStack getMeal(String string) {
        ResourceLocation location = string.contains(":") ? new ResourceLocation(string) : new ResourceLocation("harvestfestival", string);
        for (MealImpl recipe : REGISTRY.getValues()) {
            if (!recipe.getRegistryName().equals((Object)location)) continue;
            return recipe.cook(recipe.getMeal());
        }
        return null;
    }

    @Override
    public ItemStack getResult(Utensil utensil, List<ItemStack> ingredients) {
        ArrayList<Ingredient> components = new ArrayList<Ingredient>();
        for (ItemStack stack : ingredients) {
            for (Ingredient ingredient : this.getCookingComponents(stack)) {
                if (components.contains(ingredient)) continue;
                components.add(ingredient);
            }
        }
        for (RecipeHandler recipe : this.handlers) {
            ItemStack ret = recipe.getResult(utensil, ingredients, components);
            if (ret == null) continue;
            return ret;
        }
        ItemStack burnt = MealBuilder.BURNT.func_77946_l();
        burnt.func_77964_b(utensil.getIndex());
        return burnt;
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return this.getCookingComponents(stack).size() > 0;
    }

    @Override
    public boolean isKnife(ItemStack stack) {
        return this.knives.contains(ItemStackHolder.of(stack)) || this.knives.contains(ItemStackHolder.of(stack.func_77973_b(), Short.MAX_VALUE));
    }
}

