/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar.render;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.npc.gui.GuiNPCBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@HFEvents(value=Side.CLIENT)
public class CalendarRender {
    private static final BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
    public static volatile TIntIntMap grassToBlend = new TIntIntHashMap();
    public static volatile TIntIntMap leavesToBlend = new TIntIntHashMap();
    private static int fogStart = 0;
    private static int fogTarget = 0;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71462_r instanceof GuiNPCBase) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getEntity().field_70170_p.field_73011_w.getDimension() == 0) {
            if (!event.getState().func_185904_a().func_76224_d()) {
                if (fogTarget != fogStart) {
                    if (fogTarget > fogStart) {
                        fogStart += 5;
                    } else if (fogTarget < fogStart) {
                        fogStart -= 5;
                    }
                }
                Minecraft mc = MCClientHelper.getMinecraft();
                blockpos$mutableblockpos.func_189532_c(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
                int i1 = mc.field_71474_y.field_74347_j ? 10 : 5;
                int j = MathHelper.func_76128_c((double)mc.field_71439_g.field_70163_u);
                int j2 = mc.field_71441_e.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                int k2 = j - i1;
                int l2 = j + i1;
                if (k2 < j2) {
                    k2 = j2;
                }
                if (l2 < j2) {
                    l2 = j2;
                }
                Weather weather = HFApi.calendar.getWeather((World)mc.field_71441_e);
                fogTarget = k2 != l2 ? (weather == Weather.BLIZZARD ? -30000 : (weather == Weather.SNOW ? -2000 : 100)) : 100;
                if (blockpos$mutableblockpos.func_177956_o() < j2) {
                    fogTarget = 5000;
                }
                if (weather.isSnow()) {
                    GlStateManager.func_179153_c((float)(Math.min(event.getFarPlaneDistance(), 150.0f) * 0.5f));
                    GlStateManager.func_179102_b((float)((float)fogStart / 100.0f));
                }
            } else {
                fogStart = 100;
                fogTarget = 100;
            }
        }
    }

    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        Weather weather;
        if (!(event.getEntity().field_70170_p.field_73011_w.getDimension() != 0 || event.getState().func_185904_a().func_76224_d() || (weather = HFApi.calendar.getWeather(MCClientHelper.getWorld())) != Weather.SNOW && weather != Weather.BLIZZARD)) {
            event.setRed(1.0f);
            event.setBlue(1.0f);
            event.setGreen(1.0f);
        }
    }

    @SubscribeEvent
    public void getFoliageColor(BiomeEvent.GetFoliageColor event) {
        if (HFApi.calendar.getDate(MCClientHelper.getWorld()).getSeason() == Season.AUTUMN) {
            event.setNewColor(0xFF9900);
        } else {
            int leaves = ((Calendar)HFTrackers.getCalendar(MCClientHelper.getWorld())).getSeasonData().getLeavesColor();
            if (leaves != 0) {
                event.setNewColor(CalendarHelper.getBlendedColour(leavesToBlend, event.getOriginalColor(), leaves));
            }
        }
    }

    @SubscribeEvent
    public void getGrassColor(BiomeEvent.GetGrassColor event) {
        int grass = ((Calendar)HFTrackers.getCalendar(MCClientHelper.getWorld())).getSeasonData().getGrassColor();
        if (grass != 0) {
            event.setNewColor(CalendarHelper.getBlendedColour(grassToBlend, event.getOriginalColor(), grass));
        }
    }
}

