/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar.render;

import java.text.NumberFormat;
import java.util.Locale;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.CalendarAPI;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.calendar.SeasonData;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.lib.HFModInfo;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.core.util.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@HFEvents(value=Side.CLIENT)
public class CalendarHUD {
    public static boolean editingCalendar;
    public static boolean editingGold;

    private String formatTime(int time) {
        int hour = time / 1000;
        int minute = (int)((double)(time % 1000) / 20.0 * 1.2);
        if (HFCalendar.CLOCK_24H) {
            return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
        }
        boolean pm = false;
        if (hour > 12) {
            hour -= 12;
            pm = true;
        }
        if (hour == 12) {
            pm = true;
        }
        if (hour == 0) {
            hour = 12;
        }
        return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + (pm ? "PM" : "AM");
    }

    private boolean isHUDVisible() {
        return CalendarAPI.INSTANCE.getSeasonProvider(MCClientHelper.getWorld()).displayHUD();
    }

    @SubscribeEvent
    public void keyPress(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (editingCalendar || editingGold) {
            event.setCanceled(true);
            Keyboard.enableRepeatEvents((boolean)true);
            boolean save = false;
            if (Keyboard.isKeyDown((int)35)) {
                if (editingCalendar) {
                    HFCalendar.HIDE_CALENDAR_TEXTURE = !HFCalendar.HIDE_CALENDAR_TEXTURE;
                } else {
                    HFCalendar.HIDE_GOLD_TEXTURE = !HFCalendar.HIDE_GOLD_TEXTURE;
                }
            } else if (Keyboard.isKeyDown((int)17) || Keyboard.isKeyDown((int)200)) {
                if (editingCalendar) {
                    --HFCalendar.Y_CALENDAR;
                } else {
                    --HFCalendar.Y_GOLD;
                }
            } else if (Keyboard.isKeyDown((int)31) || Keyboard.isKeyDown((int)208)) {
                if (editingCalendar) {
                    ++HFCalendar.Y_CALENDAR;
                } else {
                    ++HFCalendar.Y_GOLD;
                }
            } else if (Keyboard.isKeyDown((int)32) || Keyboard.isKeyDown((int)205)) {
                if (editingCalendar) {
                    ++HFCalendar.X_CALENDAR;
                } else {
                    ++HFCalendar.X_GOLD;
                }
            } else if (Keyboard.isKeyDown((int)30) || Keyboard.isKeyDown((int)203)) {
                if (editingCalendar) {
                    --HFCalendar.X_CALENDAR;
                } else {
                    --HFCalendar.X_GOLD;
                }
            } else if (Keyboard.isKeyDown((int)28)) {
                editingCalendar = false;
                editingGold = false;
                save = true;
            }
            if (HFCalendar.X_CALENDAR >= 80) {
                HFCalendar.X_CALENDAR = 80;
            }
            if (HFCalendar.X_CALENDAR <= -6) {
                HFCalendar.X_CALENDAR = -6;
            }
            if (HFCalendar.Y_CALENDAR >= 90) {
                HFCalendar.Y_CALENDAR = 90;
            }
            if (HFCalendar.Y_CALENDAR <= -2) {
                HFCalendar.Y_CALENDAR = -2;
            }
            if (HFCalendar.X_GOLD >= 0) {
                HFCalendar.X_GOLD = 0;
            }
            if (HFCalendar.X_GOLD <= -90) {
                HFCalendar.X_GOLD = -90;
            }
            if (HFCalendar.Y_GOLD >= 95) {
                HFCalendar.Y_GOLD = 95;
            }
            if (HFCalendar.Y_GOLD <= 0) {
                HFCalendar.Y_GOLD = 0;
            }
            if (save) {
                HFCalendar.save();
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = MCClientHelper.getMinecraft();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int maxWidth = event.getResolution().func_78326_a();
            int maxHeight = event.getResolution().func_78328_b();
            if (HFCalendar.ENABLE_DATE_HUD && this.isHUDVisible()) {
                Object calendar = HFTrackers.getCalendar(MCClientHelper.getWorld());
                CalendarDate date = ((Calendar)calendar).getDate();
                Season season = HFApi.calendar.getSeasonAtCoordinates(MCClientHelper.getWorld(), new BlockPos((Entity)MCClientHelper.getPlayer()));
                if (season != null) {
                    SeasonData data = CalendarAPI.INSTANCE.getDataForSeason(season);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float adjustedX = (float)HFCalendar.X_CALENDAR / 100.0f * (float)maxWidth;
                    float adjustedY = (float)HFCalendar.Y_CALENDAR / 100.0f * (float)maxHeight;
                    if (!HFCalendar.HIDE_CALENDAR_TEXTURE) {
                        mc.field_71446_o.func_110577_a(data.getResource());
                        mc.field_71456_v.func_175174_a(adjustedX - 44.0f, adjustedY - 35.0f, 0, 0, 256, 110);
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)1.4f, (float)1.4f, (float)1.4f);
                    mc.field_71466_p.func_175063_a(Text.format("%1s %2s", season.getDisplayName(), date.getDay() + 1), adjustedX / 1.4f + 30.0f, adjustedY / 1.4f + 7.0f, -1);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    String time = this.formatTime(CalendarHelper.getScaledTime((int)CalendarHelper.getTime(MCClientHelper.getWorld())));
                    mc.field_71466_p.func_175063_a("(" + date.getWeekday().getLocalizedName() + ")" + "  " + time, adjustedX + 42.0f, adjustedY + 23.0f, -1);
                    GlStateManager.func_179121_F();
                }
            }
            if (HFCalendar.ENABLE_GOLD_HUD) {
                String text = NumberFormat.getNumberInstance(Locale.ENGLISH).format(HFTrackers.getClientPlayerTracker().getStats().getGold());
                float adjustedX = (float)HFCalendar.X_GOLD / 100.0f * (float)maxWidth;
                float adjustedY = (float)HFCalendar.Y_GOLD / 100.0f * (float)maxHeight;
                if (!HFCalendar.HIDE_GOLD_TEXTURE) {
                    mc.func_110434_K().func_110577_a(HFModInfo.ELEMENTS);
                    mc.field_71456_v.func_175174_a((float)(maxWidth - mc.field_71466_p.func_78256_a(text) - 20) + adjustedX, 2.0f + adjustedY, 244, 0, 12, 12);
                }
                int coinWidth = maxWidth - mc.field_71466_p.func_78256_a(text) - 5 + (int)adjustedX;
                mc.field_71466_p.func_175063_a(text, (float)coinWidth, 5.0f + adjustedY, -1);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

