/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar.packet;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.network.Packet;
import joshie.harvest.core.network.PenguinPacket;
import net.minecraft.entity.player.EntityPlayer;

@Packet(value=Packet.Side.CLIENT)
public class PacketSyncCalendar
extends PenguinPacket {
    private int daysPerSeason;
    private Weekday weekday;
    private int day;
    private Season season;
    private int year;

    public PacketSyncCalendar() {
    }

    public PacketSyncCalendar(CalendarDate date) {
        this.daysPerSeason = CalendarDate.DAYS_PER_SEASON;
        this.weekday = date.getWeekday();
        this.day = date.getDay();
        this.season = date.getSeason();
        this.year = date.getYear();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.daysPerSeason);
        buf.writeByte(this.weekday.ordinal());
        buf.writeInt(this.day);
        buf.writeByte(this.season.ordinal());
        buf.writeInt(this.year);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.daysPerSeason = buf.readInt();
        this.weekday = Weekday.values()[buf.readByte()];
        this.day = buf.readInt();
        this.season = Season.values()[buf.readByte()];
        this.year = buf.readInt();
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        CalendarDate date = HFApi.calendar.getDate(player.field_70170_p);
        Season previous = date.getSeason();
        date.setWeekday(this.weekday).setDay(this.day).setSeason(this.season).setYear(this.year);
        CalendarDate.DAYS_PER_SEASON = this.daysPerSeason;
        if (previous != this.season) {
            ((Calendar)HFTrackers.getCalendar(player.field_70170_p)).onSeasonChanged();
            MCClientHelper.refresh();
        }
    }
}

