/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar.command;

import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.commands.AbstractHFCommand;
import joshie.harvest.core.commands.HFCommand;
import joshie.harvest.core.handlers.HFTrackers;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

@HFCommand
public class HFCommandDay
extends AbstractHFCommand {
    @Override
    public String getCommandName() {
        return "day";
    }

    @Override
    public String getUsage() {
        return "/hf day <value>";
    }

    @Override
    public boolean execute(MinecraftServer server, ICommandSender sender, String[] parameters) {
        if (parameters != null && parameters.length == 1) {
            try {
                CalendarServer calendar = (CalendarServer)HFTrackers.getCalendar(sender.func_130014_f_());
                int day = Math.min(CalendarDate.DAYS_PER_SEASON, Math.max(1, this.parseInt(parameters[0]))) - 1;
                Season season = calendar.getDate().getSeason();
                int year = calendar.getDate().getYear() + 1;
                long leftover = server.field_71305_c[0].func_72820_D() % HFCalendar.TICKS_PER_DAY;
                CalendarHelper.setWorldTime(server, CalendarHelper.getTime(day, season, year) + leftover);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

