/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import java.util.EnumMap;
import java.util.Locale;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weather;
import net.minecraft.util.ResourceLocation;

public class SeasonData {
    private final ResourceLocation resource;
    private final int skyColor;
    private final int grassColor;
    private final int leavesColor;
    private final double celestialLengthFactor;
    private final float celestialAngleOffset;
    private final EnumMap<Weather, Double> chances = new EnumMap(Weather.class);

    public SeasonData(Season season, int skyColor, int grassColor, int leavesColor, double factor, float angle, double sunny, double rain, double typhoon, double snow, double blizzard) {
        this.resource = new ResourceLocation("harvestfestival", "textures/hud/" + season.name().toLowerCase(Locale.ENGLISH) + ".png");
        this.skyColor = skyColor;
        this.grassColor = grassColor;
        this.leavesColor = leavesColor;
        this.celestialLengthFactor = factor;
        this.celestialAngleOffset = angle;
        this.chances.put(Weather.SUNNY, sunny);
        this.chances.put(Weather.RAIN, rain);
        this.chances.put(Weather.TYPHOON, typhoon);
        this.chances.put(Weather.SNOW, snow);
        this.chances.put(Weather.BLIZZARD, blizzard);
    }

    public double getCelestialLengthFactor() {
        return this.celestialLengthFactor;
    }

    public float getCelestialAngleOffset() {
        return this.celestialAngleOffset;
    }

    public double getWeatherChance(Weather weather) {
        return this.chances.get((Object)weather);
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public int getGrassColor() {
        return this.grassColor;
    }

    public int getLeavesColor() {
        return this.leavesColor;
    }

    public ResourceLocation getResource() {
        return this.resource;
    }
}

