/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.calendar.SeasonData;
import joshie.harvest.calendar.SnowLoader;
import joshie.harvest.calendar.render.WeatherRenderer;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.MCClientHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HFWorldProvider
extends WorldProviderSurface {
    @SideOnly(value=Side.CLIENT)
    private IRenderHandler WEATHER_RENDERER;
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (this.WEATHER_RENDERER != null) {
            return this.WEATHER_RENDERER;
        }
        this.WEATHER_RENDERER = new WeatherRenderer();
        return this.WEATHER_RENDERER;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float f) {
        float brightness = super.getStarBrightness(f);
        return ((Calendar)HFTrackers.getCalendar(MCClientHelper.getWorld())).getDate().getSeason() == Season.WINTER ? brightness * 1.25f : brightness;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float f) {
        float brightness = this.field_76579_a.getSunBrightnessBody(f);
        return ((Calendar)HFTrackers.getCalendar(MCClientHelper.getWorld())).getDate().getSeason() == Season.SUMMER ? brightness * 1.25f : brightness;
    }

    public static void reset() {
        skyX = 0;
        skyZ = 0;
        skyRGBMultiplier = 0;
        skyInit = false;
    }

    public int getSkyBlendColour(World world, BlockPos center) {
        if (center.func_177958_n() == skyX && center.func_177952_p() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int original = ((Calendar)HFTrackers.getCalendar(MCClientHelper.getWorld())).getSeasonData().getSkyColor();
        int r = (original & 0xFF0000) >> 16;
        int g = (original & 0xFF00) >> 8;
        int b = original & 0xFF;
        r += (original & 0xFF0000) >> 16;
        g += (original & 0xFF00) >> 8;
        b += original & 0xFF;
        int divider = 2;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BlockPos pos = center.func_177982_a(x, 0, z);
                Biome biome = world.func_180494_b(pos);
                int colour = biome.func_76731_a(biome.func_180626_a(pos));
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                r += (original & 0xFF0000) >> 16;
                g += (original & 0xFF00) >> 8;
                b += original & 0xFF;
                divider += 2;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = center.func_177958_n();
        skyZ = center.func_177956_o();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        float f9;
        float f8;
        float f1 = this.field_76579_a.func_72826_c(partialTicks);
        float f2 = MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int l = this.getSkyBlendColour(this.field_76579_a, new BlockPos(cameraEntity));
        float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(l & 0xFF) / 255.0f;
        f4 *= f2;
        f5 *= f2;
        f6 *= f2;
        float f7 = Math.min(1.0f, this.field_76579_a.func_72867_j(partialTicks));
        if (f7 > 0.0f) {
            f8 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.6f;
            f9 = 1.0f - f7 * 0.75f;
            f4 = f4 * f9 + f8 * (1.0f - f9);
            f5 = f5 * f9 + f8 * (1.0f - f9);
            f6 = f6 * f9 + f8 * (1.0f - f9);
        }
        if ((f8 = this.field_76579_a.func_72819_i(partialTicks)) > 0.0f) {
            f9 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.2f;
            float f10 = 1.0f - (f8 /= 10.0f) * 0.75f;
            f4 = f4 * f10 + f9 * (1.0f - f10);
            f5 = f5 * f10 + f9 * (1.0f - f10);
            f6 = f6 * f10 + f9 * (1.0f - f10);
        }
        if (this.field_76579_a.func_175658_ac() > 0) {
            f9 = (float)this.field_76579_a.func_175658_ac() - partialTicks;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            f4 = f4 * (1.0f - (f9 *= 0.45f)) + 0.8f * f9;
            f5 = f5 * (1.0f - f9) + 0.8f * f9;
            f6 = f6 * (1.0f - f9) + 1.0f * f9;
        }
        return new Vec3d((double)f4, (double)f5, (double)f6);
    }

    public double clamp(double min, double max, double val) {
        return Math.max(min, Math.min(max, val));
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        Object calendar = HFTrackers.getCalendar(this.field_76579_a);
        if (calendar == null) {
            return 1.0f;
        }
        SeasonData data = ((Calendar)calendar).getSeasonData();
        int time = (int)(worldTime % HFCalendar.TICKS_PER_DAY);
        double fac = data.getCelestialLengthFactor();
        float chylex = (float)(this.clamp(0.0, 1000.0, time) + 11000.0 * (this.clamp(0.0, 11000.0, (double)time - 1000.0) / 11000.0) * fac + this.clamp(0.0, 1000.0, (double)time - 12000.0) + 11000.0 * (this.clamp(0.0, 11000.0, (double)time - 12000.0) / 11000.0) * (2.0 - fac));
        float angle = chylex / (float)HFCalendar.TICKS_PER_DAY - 0.25f;
        return angle + data.getCelestialAngleOffset();
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return HFApi.calendar.getDate(this.field_76579_a).getSeason() != Season.SUMMER && super.isBlockHighHumidity(pos);
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        Weather weather = HFApi.calendar.getWeather(this.field_76579_a);
        if (weather.isSnow()) {
            Biome biome = this.field_76579_a.func_180494_b(pos);
            float f = biome.func_180626_a(pos);
            if (f > 0.15f) {
                IBlockState state;
                if (!checkLight) {
                    return true;
                }
                if (biome.func_76738_d() && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && this.field_76579_a.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (state = this.field_76579_a.func_180495_p(pos)).func_185904_a() == Material.field_151579_a && Blocks.field_150431_aC.func_176196_c(this.field_76579_a, pos)) {
                    if (SnowLoader.SNOW_LAYER != null && !biome.func_150559_j()) {
                        HFApi.tickable.addTickable(this.field_76579_a, pos, SnowLoader.SNOW_LAYER);
                    }
                    return true;
                }
                return false;
            }
            return super.canSnowAt(pos, checkLight);
        }
        return false;
    }

    public void updateWeather() {
        Object calendar = HFTrackers.getCalendar(this.field_76579_a);
        float rainStrength = ((Calendar)calendar).getTodaysRainStrength();
        float thunderStrength = ((Calendar)calendar).getTodaysStormStrength();
        if (this.field_76579_a.field_73004_o > rainStrength) {
            this.field_76579_a.field_73004_o -= 0.01f;
        } else if (this.field_76579_a.field_73004_o < rainStrength) {
            this.field_76579_a.field_73004_o += 0.01f;
        }
        if (this.field_76579_a.field_73017_q > thunderStrength) {
            this.field_76579_a.field_73017_q -= 0.1f;
        } else if (this.field_76579_a.field_73017_q < thunderStrength) {
            this.field_76579_a.field_73017_q += 0.01f;
        }
    }
}

