/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.SeasonProvider;
import joshie.harvest.calendar.HFWorldProvider;
import joshie.harvest.calendar.SeasonProviderHidden;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.util.HFLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;

@HFLoader(priority=9)
public class HFCalendar {
    private static final SeasonProvider HIDDEN = new SeasonProviderHidden();
    public static Configuration CONFIG;
    public static int DAYS_PER_SEASON_INTEGRATED;
    private static int DAYS_PER_SEASON_DEDICATED;
    public static long TICKS_PER_DAY;
    public static boolean ENABLE_SUNNY;
    public static boolean ENABLE_RAIN;
    public static boolean ENABLE_TYPHOON;
    public static boolean ENABLE_SNOW;
    public static boolean ENABLE_BLIZZARD;
    public static boolean ENABLE_DATE_HUD;
    public static boolean ENABLE_GOLD_HUD;
    public static boolean SNOW_TICKER;
    public static int OVERWORLD_ID;
    public static boolean HIDE_CALENDAR_TEXTURE;
    public static boolean HIDE_GOLD_TEXTURE;
    public static int X_CALENDAR;
    public static int Y_CALENDAR;
    public static int X_GOLD;
    public static int Y_GOLD;
    public static boolean CLOCK_24H;

    public static void preInit() {
        DimensionType seasons = DimensionType.register((String)"seasons", (String)"seasons", (int)OVERWORLD_ID, HFWorldProvider.class, (boolean)true);
        DimensionManager.unregisterDimension((int)0);
        DimensionManager.registerDimension((int)0, (DimensionType)seasons);
        HFApi.calendar.registerSeasonProvider(1, HIDDEN);
        HFApi.calendar.registerSeasonProvider(-1, HIDDEN);
    }

    public static void save() {
        ConfigHelper.setConfig(CONFIG);
        ConfigHelper.setCategory("calendar");
        ConfigHelper.setInteger("HUD > Calendar X", X_CALENDAR);
        ConfigHelper.setInteger("HUD > Calendar Y", Y_CALENDAR);
        ConfigHelper.setBoolean("HUD > Calendar Hide Texture", HIDE_CALENDAR_TEXTURE);
        ConfigHelper.setInteger("HUD > Gold X", X_GOLD);
        ConfigHelper.setInteger("HUD > Gold Y", Y_GOLD);
        ConfigHelper.setBoolean("HUD > Gold Hide Texture", HIDE_GOLD_TEXTURE);
        CONFIG.save();
    }

    public static void configure() {
        CONFIG = ConfigHelper.getConfig();
        OVERWORLD_ID = ConfigHelper.getInteger("Overworld ID", 3);
        DAYS_PER_SEASON_INTEGRATED = ConfigHelper.getInteger("Integrated Server > Days per season", 30);
        DAYS_PER_SEASON_DEDICATED = ConfigHelper.getInteger("Dedicated Server > Days per season", 365);
        TICKS_PER_DAY = ConfigHelper.getInteger("Ticks per day", 24000);
        ENABLE_SUNNY = ConfigHelper.getBoolean("Weather > Enable sunny", true);
        ENABLE_RAIN = ConfigHelper.getBoolean("Weather > Enable rain", true);
        ENABLE_TYPHOON = ConfigHelper.getBoolean("Weather > Enable typhoon", true);
        ENABLE_SNOW = ConfigHelper.getBoolean("Weather > Enable snow", true);
        ENABLE_BLIZZARD = ConfigHelper.getBoolean("Weather > Enable blizzard", true);
        HIDE_CALENDAR_TEXTURE = ConfigHelper.getBoolean("HUD > Calendar Hide Texture", false);
        X_CALENDAR = ConfigHelper.getInteger("HUD > Calendar X", 0);
        Y_CALENDAR = ConfigHelper.getInteger("HUD > Calendar Y", 0);
        HIDE_GOLD_TEXTURE = ConfigHelper.getBoolean("HUD > Gold Hide Texture", false);
        X_GOLD = ConfigHelper.getInteger("HUD > Gold X", 0);
        Y_GOLD = ConfigHelper.getInteger("HUD > Gold Y", 0);
        ENABLE_DATE_HUD = ConfigHelper.getBoolean("HUD > Enable data", true);
        ENABLE_GOLD_HUD = ConfigHelper.getBoolean("HUD > Enable gold", true);
        SNOW_TICKER = ConfigHelper.getBoolean("Remove snow faster", true);
        CLOCK_24H = ConfigHelper.getBoolean("24 hour clock", true);
    }

    public static void onServerStarting() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        CalendarDate.DAYS_PER_SEASON = server.func_71262_S() ? DAYS_PER_SEASON_DEDICATED : DAYS_PER_SEASON_INTEGRATED;
    }
}

