/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import java.util.Random;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.CalendarAPI;
import joshie.harvest.calendar.CalendarData;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.calendar.SeasonData;
import joshie.harvest.calendar.packet.PacketSetCalendar;
import joshie.harvest.calendar.packet.PacketSyncForecast;
import joshie.harvest.calendar.packet.PacketSyncStrength;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CalendarServer
extends Calendar {
    private final CalendarDate DATE = new CalendarDate(0, Season.SPRING, 1);
    private static final Random rand = new Random();
    private CalendarData data;

    public void setWorld(CalendarData data, World world) {
        this.data = data;
        super.setWorld(world);
        this.recalculateAndUpdate(world);
    }

    @Override
    public CalendarDate getDate() {
        return this.DATE;
    }

    public void newDay(World world) {
        this.recalculateAndUpdate(world);
        Weather[] newForecast = new Weather[7];
        System.arraycopy(this.forecast, 1, newForecast, 0, 6);
        this.forecast = newForecast;
        this.updateForecast();
    }

    private Season getNextSeason(Season season) {
        if (season == Season.SPRING) {
            return Season.SUMMER;
        }
        if (season == Season.SUMMER) {
            return Season.AUTUMN;
        }
        if (season == Season.AUTUMN) {
            return Season.WINTER;
        }
        return Season.SPRING;
    }

    public void syncToPlayer(EntityPlayer player) {
        this.recalculate(player.field_70170_p);
        PacketHandler.sendToClient(new PacketSetCalendar(this.DATE), player);
        PacketHandler.sendToClient(new PacketSyncForecast(this.forecast), player);
        PacketHandler.sendToClient(new PacketSyncStrength(this.rainStrength, this.stormStrength), player);
    }

    public void recalculate(World world) {
        CalendarHelper.setDate(world, this.DATE);
        HFTrackers.markCalendarDirty();
    }

    public void recalculateAndUpdate(World world) {
        this.recalculate(world);
        PacketHandler.sendToEveryone(new PacketSetCalendar(this.DATE));
    }

    public void setTodaysWeather(Weather weather) {
        this.forecast[0] = weather;
        this.updateWeatherStrength();
        HFTrackers.markCalendarDirty();
        PacketHandler.sendToEveryone(new PacketSyncForecast(this.forecast));
    }

    private Weather getRandomWeather(int day, Season season) {
        if (day > CalendarDate.DAYS_PER_SEASON) {
            season = this.getNextSeason(season);
        }
        SeasonData data = CalendarAPI.INSTANCE.getDataForSeason(season);
        for (Weather weather : Weather.values()) {
            double chance;
            if (!this.isWeatherEnabled(weather) || !((chance = data.getWeatherChance(weather)) > 0.0) || !(rand.nextDouble() * 100.0 < chance)) continue;
            return weather;
        }
        return Weather.SUNNY;
    }

    private boolean isWeatherEnabled(Weather weather) {
        switch (weather) {
            case SUNNY: {
                return HFCalendar.ENABLE_SUNNY;
            }
            case RAIN: {
                return HFCalendar.ENABLE_RAIN;
            }
            case TYPHOON: {
                return HFCalendar.ENABLE_TYPHOON;
            }
            case SNOW: {
                return HFCalendar.ENABLE_SNOW;
            }
            case BLIZZARD: {
                return HFCalendar.ENABLE_BLIZZARD;
            }
        }
        return false;
    }

    private void updateForecast() {
        for (int i = 0; i < 7; ++i) {
            if (this.forecast[i] != null) continue;
            this.forecast[i] = this.getRandomWeather(this.getDate().getDay() + i, this.getDate().getSeason());
        }
        this.updateWeatherStrength();
        HFTrackers.markCalendarDirty();
        PacketHandler.sendToEveryone(new PacketSyncForecast(this.forecast));
    }

    public void markDirty() {
        this.data.func_76185_a();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Date")) {
            CalendarDate date = CalendarDate.fromNBT(nbt.func_74775_l("Date"));
            this.DATE.setDay(date.getDay()).setWeekday(date.getWeekday()).setSeason(date.getSeason()).setYear(date.getYear());
        }
        this.rainStrength = nbt.func_74760_g("Rain");
        this.stormStrength = nbt.func_74760_g("Storm");
        for (int i = 0; i < 7; ++i) {
            this.forecast[i] = Weather.values()[nbt.func_74771_c("Day" + i)];
            if (this.forecast[i] != null) continue;
            this.forecast[i] = Weather.SUNNY;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Date", (NBTBase)this.DATE.toNBT());
        nbt.func_74776_a("Rain", this.rainStrength);
        nbt.func_74776_a("Storm", this.stormStrength);
        for (int i = 0; i < 7; ++i) {
            Weather weather = this.forecast[i];
            if (weather == null) {
                weather = Weather.SUNNY;
            }
            nbt.func_74774_a("Day" + i, (byte)weather.ordinal());
        }
        return nbt;
    }
}

