/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import java.text.NumberFormat;
import java.util.Locale;
import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.api.core.ISeasonData;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.CalendarHelper;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import joshie.harvest.core.lib.HFModInfo;
import joshie.harvest.npc.gui.ContainerNPC;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class CalendarRender {
    private String formatTime(int time) {
        int hour = time / 1000;
        int minute = (int)((double)(time % 1000) / 20.0 * 1.2);
        return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            if (MCClientHelper.getPlayer().field_71070_bA instanceof ContainerNPC) {
                event.setCanceled(true);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = MCClientHelper.getMinecraft();
            mc.field_71424_I.func_76320_a("calendarHUD");
            Calendar calendar = HFTrackers.getCalendar();
            ICalendarDate date = calendar.getDate();
            ISeasonData data = calendar.getSeasonData();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(data.getResource());
            mc.field_71456_v.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.4f, (float)1.4f, (float)1.4f);
            mc.field_71466_p.func_175063_a(data.getLocalized() + " " + date.getDay(), 30.0f, 7.0f, -1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            String time = this.formatTime(CalendarHelper.getScaledTime((int)CalendarHelper.getTime(MCClientHelper.getWorld())));
            mc.field_71466_p.func_175063_a("(" + date.getWeekday().name().substring(0, 3) + ")" + "  " + time, 42.0f, 23.0f, -1);
            GlStateManager.func_179121_F();
            mc.func_110434_K().func_110577_a(HFModInfo.elements);
            String text = NumberFormat.getNumberInstance(Locale.US).format(HFTrackers.getClientPlayerTracker().getStats().getGold());
            int width = event.getResolution().func_78326_a();
            mc.field_71456_v.func_73729_b(width - mc.field_71466_p.func_78256_a(text) - 20, 2, 244, 0, 12, 12);
            int coinWidth = width - mc.field_71466_p.func_78256_a(text) - 5;
            mc.field_71466_p.func_175063_a(text, (float)coinWidth, 5.0f, -1);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (!event.getState().func_185904_a().func_76224_d()) {
            Weather weather = HFTrackers.getCalendar().getTodaysWeather();
            if (weather == Weather.BLIZZARD) {
                GlStateManager.func_187412_c((int)2917, (int)2048);
                GL11.glFogf((int)2914, (float)0.15f);
            } else if (weather == Weather.SNOW) {
                GlStateManager.func_187412_c((int)2917, (int)2048);
                GL11.glFogf((int)2914, (float)0.01f);
            }
        }
    }

    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        Weather weather;
        if (!(event.getState().func_185904_a().func_76224_d() || (weather = HFTrackers.getCalendar().getTodaysWeather()) != Weather.SNOW && weather != Weather.BLIZZARD)) {
            event.setRed(1.0f);
            event.setBlue(1.0f);
            event.setGreen(1.0f);
        }
    }
}

