/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import gnu.trove.map.TIntIntMap;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.player.PlayerTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CalendarHelper {
    private static final Season[] SEASONS = (Season[])Season.class.getEnumConstants();
    private static final Weekday[] DAYS = (Weekday[])Weekday.class.getEnumConstants();

    private static Weekday getWeekday(int days) {
        int modulus = days % 7;
        if (modulus < 0) {
            modulus = 0;
        }
        return DAYS[modulus];
    }

    private static Weekday getWeekday(long time) {
        return CalendarHelper.getWeekday(CalendarHelper.getElapsedDays(time));
    }

    static void setDate(World world, CalendarDate date) {
        long time = world.func_72820_D();
        Season previous = date.getSeason();
        date.setWeekday(CalendarHelper.getWeekday(time)).setDay(CalendarHelper.getDay(time)).setSeason(CalendarHelper.getSeason(time)).setYear(CalendarHelper.getYear(time));
        if (previous != date.getSeason()) {
            ((Calendar)HFTrackers.getCalendar(world)).onSeasonChanged();
        }
    }

    private static int getYear(long totalTime) {
        return (int)Math.floor(CalendarHelper.getElapsedDays(totalTime) / 4 / CalendarDate.DAYS_PER_SEASON);
    }

    public static Season getSeason(long totalTime) {
        return SEASONS[Math.max(0, (int)Math.floor(CalendarHelper.getElapsedDays(totalTime) / CalendarDate.DAYS_PER_SEASON % 4))];
    }

    private static int getDay(long totalTime) {
        return CalendarHelper.getElapsedDays(totalTime) % CalendarDate.DAYS_PER_SEASON;
    }

    public static int getElapsedDays(long totalTime) {
        return (int)(totalTime / HFCalendar.TICKS_PER_DAY);
    }

    private static int getTotalDays(int day, Season season, int year) {
        int season_days = CalendarDate.DAYS_PER_SEASON * season.ordinal();
        int year_days = (year - 1) * (CalendarDate.DAYS_PER_SEASON * 4);
        return day + season_days + year_days;
    }

    public static int getTotalDays(CalendarDate date) {
        int current_days = date.getDay();
        int season_days = CalendarDate.DAYS_PER_SEASON * date.getSeason().ordinal();
        int year_days = (date.getYear() - 1) * (CalendarDate.DAYS_PER_SEASON * 4);
        return current_days + season_days + year_days;
    }

    public static int getYearsPassed(CalendarDate birthday, CalendarDate date) {
        double current_total_days = CalendarHelper.getTotalDays(date);
        double birthday_total_days = CalendarHelper.getTotalDays(birthday);
        int one_year = CalendarDate.DAYS_PER_SEASON * 4;
        int years_passed = (int)Math.floor(current_total_days / (double)one_year);
        int birthday_years = (int)Math.floor(birthday_total_days / (double)one_year);
        return Math.max(0, years_passed - birthday_years);
    }

    public static long getTime(int day, Season season, int year) {
        return (long)CalendarHelper.getTotalDays(day, season, year) * HFCalendar.TICKS_PER_DAY;
    }

    public static long getTime(World world) {
        return (world.func_72820_D() + 6000L) % HFCalendar.TICKS_PER_DAY;
    }

    public static int getScaledTime(int time) {
        return (int)((double)time / (double)HFCalendar.TICKS_PER_DAY * 24000.0);
    }

    public static boolean haveYearsPassed(World world, EntityPlayer player, int year) {
        CalendarDate date;
        CalendarDate playersBirthday = ((PlayerTracker)HFTrackers.getPlayerTrackerFromPlayer(player)).getStats().getBirthday();
        return CalendarHelper.getYearsPassed(playersBirthday, date = HFApi.calendar.getDate(world)) >= year;
    }

    public static void setWorldTime(MinecraftServer server, long worldTime) {
        worldTime = Math.max(0L, worldTime);
        for (int j = 0; j < server.field_71305_c.length; ++j) {
            WorldServer worldserver = server.field_71305_c[j];
            worldserver.func_72877_b(worldTime);
        }
        CalendarServer calendar = (CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0]);
        calendar.recalculateAndUpdate((World)server.field_71305_c[0]);
    }

    public static int getBlendedColour(TIntIntMap map, int original, int additional) {
        try {
            int ret = map.get(original);
            if (ret != map.getNoEntryValue()) {
                return ret;
            }
            int size = 2;
            int r = (original & 0xFF0000) >> 16;
            int g = (original & 0xFF00) >> 8;
            int b = original & 0xFF;
            int value = ((r += (additional & 0xFF0000) >> 16) / size & 0xFF) << 16 | ((g += (additional & 0xFF00) >> 8) / size & 0xFF) << 8 | (b += additional & 0xFF) / size & 0xFF;
            map.put(original, value);
            return value;
        }
        catch (IndexOutOfBoundsException exception) {
            return original;
        }
    }
}

