/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.Weekday;
import joshie.harvest.api.core.ISeasonData;
import joshie.harvest.core.helpers.CalendarHelper;
import net.minecraft.nbt.NBTTagCompound;

public class CalendarDate
implements ICalendarDate {
    private int day;
    private Season season;
    private int year;
    private ISeasonData data;

    public CalendarDate() {
    }

    public CalendarDate(int day, Season season, int year) {
        this.day = day;
        this.season = season;
        this.year = year;
        this.data = HFApi.CALENDAR.getDataForSeason(season);
    }

    public CalendarDate(ICalendarDate date) {
        this.day = date.getDay();
        this.season = date.getSeason();
        this.year = date.getYear();
        this.data = date.getSeasonData();
    }

    @Override
    public ICalendarDate setDay(int day) {
        this.day = day;
        return this;
    }

    @Override
    public ICalendarDate setSeason(Season season) {
        Season previous = this.season;
        this.season = season;
        if (previous != season) {
            this.data = HFApi.CALENDAR.getDataForSeason(season);
        }
        return this;
    }

    @Override
    public ICalendarDate setYear(int year) {
        this.year = year;
        return this;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public Season getSeason() {
        return this.season;
    }

    @Override
    public ISeasonData getSeasonData() {
        return this.data;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public Weekday getWeekday() {
        return Weekday.values()[CalendarHelper.getTotalDays(this) % 7];
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.day = nbt.func_74771_c("DayOfMonth");
        this.season = Season.values()[nbt.func_74771_c("Season")];
        this.year = nbt.func_74765_d("Year");
        this.data = HFApi.CALENDAR.getDataForSeason(this.season);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("DayOfMonth", (byte)this.day);
        nbt.func_74774_a("Season", (byte)this.season.ordinal());
        nbt.func_74777_a("Year", (short)this.year);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICalendarDate other = (ICalendarDate)obj;
        if (this.day != other.getDay()) {
            return false;
        }
        if (this.season != other.getSeason()) {
            return false;
        }
        return this.year == other.getYear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + (this.season == null ? 0 : this.season.hashCode());
        result = 31 * result + this.year;
        return result;
    }
}

