/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.CalendarManager;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.SeasonProvider;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.Calendar;
import joshie.harvest.calendar.SeasonData;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.util.HFApiImplementation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@HFApiImplementation
public class CalendarAPI
implements CalendarManager {
    public static final CalendarAPI INSTANCE = new CalendarAPI();
    private final EnumMap<Season, SeasonData> data = new EnumMap(Season.class);
    private final TIntObjectMap<SeasonProvider> providers = new TIntObjectHashMap();

    private CalendarAPI() {
        this.data.put(Season.SPRING, new SeasonData(Season.SPRING, 8900346, 0, 8435564, 0.65, 0.0f, 80.0, 100.0, 0.0, 0.0, 0.0));
        this.data.put(Season.SUMMER, new SeasonData(Season.SUMMER, 7972863, 4889646, 0, 0.4, 0.0011f, 95.0, 75.0, 100.0, 0.0, 0.0));
        this.data.put(Season.AUTUMN, new SeasonData(Season.AUTUMN, 9223894, 11688192, 0xFF9900, 1.08, -0.07f, 50.0, 100.0, 0.0, 0.0, 0.0));
        this.data.put(Season.WINTER, new SeasonData(Season.WINTER, 0xFFFFFF, 0xFFFFFF, 0xCCCCCC, 1.56, -0.1375f, 45.0, 0.0, 0.0, 90.0, 100.0));
    }

    @Override
    public void registerSeasonProvider(int dimension, SeasonProvider provider) {
        this.providers.put(dimension, (Object)provider);
    }

    @Override
    public SeasonProvider getSeasonProvider(@Nonnull World world) {
        SeasonProvider provider = (SeasonProvider)this.providers.get(world.field_73011_w.getDimension());
        return provider != null ? provider : HFTrackers.getCalendar(world);
    }

    @Override
    public Season getSeasonAtCoordinates(World world, BlockPos pos) {
        return this.getSeasonProvider(world).getSeasonAtPos(world, pos);
    }

    @Override
    public Weather getWeather(World world) {
        return ((Calendar)HFTrackers.getCalendar(world)).getTodaysWeather();
    }

    @Override
    public CalendarDate getDate(World world) {
        return ((Calendar)HFTrackers.getCalendar(world)).getDate();
    }

    @Nonnull
    public SeasonData getDataForSeason(Season season) {
        SeasonData seasonData = this.data.get((Object)season);
        return seasonData != null ? seasonData : this.data.get((Object)Season.SPRING);
    }
}

