/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.calendar;

import javax.annotation.Nullable;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.api.calendar.SeasonProvider;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.CalendarAPI;
import joshie.harvest.calendar.SeasonData;
import joshie.harvest.core.HFTracker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class Calendar
extends HFTracker
implements SeasonProvider {
    private SeasonData data;
    protected Weather[] forecast = new Weather[7];
    protected float rainStrength;
    protected float stormStrength;

    public abstract CalendarDate getDate();

    @Override
    public Season getSeasonAtPos(World world, @Nullable BlockPos pos) {
        return this.getDate().getSeason();
    }

    public SeasonData getSeasonData() {
        if (this.data == null) {
            this.onSeasonChanged();
        }
        return this.data;
    }

    public void onSeasonChanged() {
        this.data = CalendarAPI.INSTANCE.getDataForSeason(this.getDate().getSeason());
    }

    public Calendar() {
        for (int i = 0; i < 7; ++i) {
            this.forecast[i] = Weather.SUNNY;
        }
    }

    public Weather getTodaysWeather() {
        return this.forecast[0] != null ? this.forecast[0] : Weather.SUNNY;
    }

    public float getTodaysRainStrength() {
        return this.rainStrength;
    }

    public float getTodaysStormStrength() {
        return this.stormStrength;
    }

    public void updateWeatherStrength() {
        switch (this.forecast[0]) {
            case SUNNY: {
                this.rainStrength = 0.0f;
                this.stormStrength = 0.0f;
                break;
            }
            case RAIN: 
            case SNOW: {
                this.rainStrength = 1.0f;
                this.stormStrength = 0.0f;
                break;
            }
            case TYPHOON: {
                this.rainStrength = 2.0f;
                this.stormStrength = 1.0f;
                break;
            }
            case BLIZZARD: {
                this.rainStrength = 2.0f;
                this.stormStrength = 0.0f;
                break;
            }
        }
    }
}

