/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.buildings.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import joshie.harvest.buildings.BuildingHelper;
import joshie.harvest.buildings.BuildingImpl;
import joshie.harvest.buildings.HFBuildings;
import joshie.harvest.buildings.render.BuildingAccess;
import joshie.harvest.buildings.render.BuildingRenderer;
import joshie.harvest.buildings.render.BuildingVertexUploader;
import joshie.harvest.buildings.render.RenderKey;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@HFEvents(value=Side.CLIENT)
public class PreviewEvent {
    public static final Cache<RenderKey, BuildingRenderer> CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(64L).build();
    private final BuildingVertexUploader vertexUploader = new BuildingVertexUploader();
    private static final float offset = 0.00390625f;
    private ItemStack held;
    private BuildingImpl building;

    private BuildingRenderer getRenderer(World world, EntityPlayerSP player) throws ExecutionException {
        RayTraceResult raytrace;
        if (player == null) {
            return null;
        }
        ItemStack stack = player.func_184614_ca();
        if (this.isInvalidStack(stack)) {
            stack = player.func_184592_cb();
        }
        if (this.isInvalidStack(stack)) {
            return null;
        }
        if (stack != this.held) {
            this.building = stack.func_77973_b() == HFBuildings.BLUEPRINTS ? (BuildingImpl)HFBuildings.BLUEPRINTS.getObjectFromStack(stack) : (BuildingImpl)HFBuildings.STRUCTURES.getObjectFromStack(stack);
            this.held = stack;
        }
        if ((raytrace = BuildingHelper.rayTrace((EntityPlayer)player, 128.0, 0.0f)) == null || raytrace.func_178782_a() == null) {
            return null;
        }
        RenderKey key = BuildingHelper.getPositioning(stack, world, raytrace, this.building, (EntityPlayer)player, false);
        if (key != null) {
            return ((BuildingRenderer)CACHE.get((Object)key, () -> new BuildingRenderer(new BuildingAccess(this.building, key.getMirror(), key.getRotation()), key))).setPosition(key.getPos());
        }
        return null;
    }

    private boolean isBuildingItem(ItemStack stack) {
        return stack.func_77973_b() == HFBuildings.BLUEPRINTS || stack.func_77973_b() == HFBuildings.STRUCTURES;
    }

    private boolean isInvalidStack(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || !this.isBuildingItem(stack);
    }

    private void renderRenderer(EntityPlayerSP player, BuildingRenderer renderer, float partialTick) {
        BlockPos pos = renderer.getPos();
        GlStateManager.func_179094_E();
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTick;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTick;
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTick;
        GlStateManager.func_179137_b((double)(-posX + 0.00390625), (double)(-posY + 0.00390625), (double)(-posZ + 0.00390625));
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        renderer.draw(this.vertexUploader);
        GlStateManager.func_179109_b((float)(-pos.func_177958_n()), (float)(-pos.func_177956_o()), (float)(-pos.func_177952_p()));
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderBuildingPreview(RenderWorldLastEvent event) throws ExecutionException {
        EntityPlayerSP player = MCClientHelper.getPlayer();
        BuildingRenderer renderer = this.getRenderer(player.field_70170_p, player);
        if (renderer != null) {
            this.renderRenderer(player, renderer, event.getPartialTicks());
        }
    }
}

